/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.tags.tags5xx;

import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.FRBRFunction;
import de.gwdg.metadataqa.marc.definition.Indicator;
import de.gwdg.metadataqa.marc.definition.general.parser.LinkageParser;

public class Tag562
extends DataFieldDefinition {
    private static Tag562 uniqueInstance;

    private Tag562() {
        this.initialize();
        this.postCreation();
    }

    public static Tag562 getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new Tag562();
        }
        return uniqueInstance;
    }

    private void initialize() {
        this.tag = "562";
        this.label = "Copy and Version Identification Note";
        this.mqTag = "CopyAndVersionIdentification";
        this.cardinality = Cardinality.Repeatable;
        this.descriptionUrl = "https://www.loc.gov/marc/bibliographic/bd562.html";
        this.setCompilanceLevels("O");
        this.ind1 = new Indicator();
        this.ind2 = new Indicator();
        this.setSubfieldsWithCardinality("a", "Identifying markings", "R", "b", "Copy identification", "R", "c", "Version identification", "R", "d", "Presentation format", "R", "e", "Number of copies", "R", "3", "Materials specified", "NR", "5", "Institution to which field applies", "NR", "6", "Linkage", "NR", "8", "Field link and sequence number", "R");
        this.getSubfield("6").setContentParser(LinkageParser.getInstance());
        this.getSubfield("a").setMqTag("identifyingMarkings").setFrbrFunctions(FRBRFunction.DiscoveryIdentify).setCompilanceLevels("A");
        this.getSubfield("b").setMqTag("copyIdentification").setFrbrFunctions(FRBRFunction.DiscoveryIdentify).setCompilanceLevels("A");
        this.getSubfield("c").setMqTag("versionIdentification").setFrbrFunctions(FRBRFunction.DiscoveryIdentify).setCompilanceLevels("A");
        this.getSubfield("d").setMqTag("presentationFormat").setFrbrFunctions(FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoverySelect).setCompilanceLevels("A");
        this.getSubfield("e").setMqTag("numberOfCopies").setCompilanceLevels("A");
        this.getSubfield("3").setMqTag("materialsSpecified").setFrbrFunctions(FRBRFunction.DiscoveryIdentify).setCompilanceLevels("O");
        this.getSubfield("5").setMqTag("institutionToWhichFieldApplies").setFrbrFunctions(FRBRFunction.ManagementProcess, FRBRFunction.ManagementDisplay).setCompilanceLevels("A");
        this.getSubfield("6").setBibframeTag("linkage").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("A");
        this.getSubfield("8").setMqTag("fieldLink").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("O");
    }
}

