/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.tags.tags5xx;

import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.FRBRFunction;
import de.gwdg.metadataqa.marc.definition.Indicator;
import de.gwdg.metadataqa.marc.definition.general.parser.LinkageParser;

public class Tag545
extends DataFieldDefinition {
    private static Tag545 uniqueInstance;

    private Tag545() {
        this.initialize();
        this.postCreation();
    }

    public static Tag545 getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new Tag545();
        }
        return uniqueInstance;
    }

    private void initialize() {
        this.tag = "545";
        this.label = "Biographical or Historical Data";
        this.mqTag = "BiographicalOrHistoricalData";
        this.cardinality = Cardinality.Repeatable;
        this.descriptionUrl = "https://www.loc.gov/marc/bibliographic/bd545.html";
        this.setCompilanceLevels("O");
        this.ind1 = new Indicator("Type of data").setCodes(" ", "No information provided", "0", "Biographical sketch", "1", "Administrative history").setMqTag("type").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess, FRBRFunction.ManagementSort);
        this.ind2 = new Indicator();
        this.setSubfieldsWithCardinality("a", "Biographical or historical data", "NR", "b", "Expansion", "NR", "u", "Uniform Resource Identifier", "R", "6", "Linkage", "NR", "8", "Field link and sequence number", "R");
        this.getSubfield("6").setContentParser(LinkageParser.getInstance());
        this.getSubfield("a").setMqTag("rdf:value").setFrbrFunctions(FRBRFunction.DiscoveryIdentify).setCompilanceLevels("M");
        this.getSubfield("b").setMqTag("expansion").setFrbrFunctions(FRBRFunction.DiscoveryIdentify).setCompilanceLevels("O");
        this.getSubfield("u").setMqTag("uri").setFrbrFunctions(FRBRFunction.DiscoveryObtain).setCompilanceLevels("O");
        this.getSubfield("6").setBibframeTag("linkage").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("A");
        this.getSubfield("8").setMqTag("fieldLink").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("O");
    }
}

