/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.tags.tags5xx;

import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.Indicator;
import de.gwdg.metadataqa.marc.definition.general.parser.LinkageParser;

public class Tag542
extends DataFieldDefinition {
    private static Tag542 uniqueInstance;

    private Tag542() {
        this.initialize();
        this.postCreation();
    }

    public static Tag542 getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new Tag542();
        }
        return uniqueInstance;
    }

    private void initialize() {
        this.tag = "542";
        this.label = "Information Relating to Copyright Status";
        this.mqTag = "CopyrightStatus";
        this.cardinality = Cardinality.Repeatable;
        this.descriptionUrl = "https://www.loc.gov/marc/bibliographic/bd542.html";
        this.setCompilanceLevels("O");
        this.ind1 = new Indicator("Privacy").setCodes(" ", "No information provided", "0", "Private", "1", "Not private").setMqTag("privacy");
        this.ind2 = new Indicator();
        this.setSubfieldsWithCardinality("a", "Personal creator", "NR", "b", "Personal creator death date", "NR", "c", "Corporate creator", "NR", "d", "Copyright holder", "R", "e", "Copyright holder contact information", "R", "f", "Copyright statement", "R", "g", "Copyright date", "NR", "h", "Copyright renewal date", "R", "i", "Publication date", "NR", "j", "Creation date", "NR", "k", "Publisher", "R", "l", "Copyright status", "NR", "m", "Publication status", "NR", "n", "Note", "R", "o", "Research date", "NR", "p", "Country of publication or creation", "R", "q", "Supplying agency", "NR", "r", "Jurisdiction of copyright assessment", "NR", "s", "Source of information", "NR", "u", "Uniform Resource Identifier", "R", "3", "Materials specified", "NR", "6", "Linkage", "NR", "8", "Field link and sequence number", "R");
        this.getSubfield("6").setContentParser(LinkageParser.getInstance());
        this.getSubfield("a").setMqTag("personalCreator").setCompilanceLevels("O");
        this.getSubfield("b").setMqTag("personalCreatorDeathDate").setCompilanceLevels("O");
        this.getSubfield("c").setMqTag("corporateCreator").setCompilanceLevels("O");
        this.getSubfield("d").setMqTag("copyrightHolder").setCompilanceLevels("A");
        this.getSubfield("e").setMqTag("copyrightHolderContact").setCompilanceLevels("O");
        this.getSubfield("f").setMqTag("copyrightStatement").setCompilanceLevels("A");
        this.getSubfield("g").setMqTag("copyrightDate").setCompilanceLevels("A");
        this.getSubfield("h").setMqTag("copyrightRenewalDate").setCompilanceLevels("A");
        this.getSubfield("i").setMqTag("publicationDate").setCompilanceLevels("O");
        this.getSubfield("j").setMqTag("creationDate").setCompilanceLevels("O");
        this.getSubfield("k").setMqTag("publisher").setCompilanceLevels("O");
        this.getSubfield("l").setMqTag("copyrightStatus").setCompilanceLevels("O");
        this.getSubfield("m").setMqTag("publicationStatus").setCompilanceLevels("A");
        this.getSubfield("n").setMqTag("note").setCompilanceLevels("O");
        this.getSubfield("o").setMqTag("researchDate").setCompilanceLevels("O");
        this.getSubfield("p").setMqTag("country").setCompilanceLevels("A");
        this.getSubfield("q").setMqTag("supplyingAgency").setCompilanceLevels("O");
        this.getSubfield("r").setMqTag("jurisdiction").setCompilanceLevels("A");
        this.getSubfield("s").setMqTag("source").setCompilanceLevels("O");
        this.getSubfield("u").setMqTag("uri").setCompilanceLevels("O");
        this.getSubfield("3").setMqTag("materialsSpecified").setCompilanceLevels("O");
        this.getSubfield("6").setBibframeTag("linkage").setCompilanceLevels("A");
        this.getSubfield("8").setMqTag("fieldLink").setCompilanceLevels("O");
    }
}

