/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.tags.tags5xx;

import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.FRBRFunction;
import de.gwdg.metadataqa.marc.definition.Indicator;
import de.gwdg.metadataqa.marc.definition.general.parser.LinkageParser;

public class Tag541
extends DataFieldDefinition {
    private static Tag541 uniqueInstance;

    private Tag541() {
        this.initialize();
        this.postCreation();
    }

    public static Tag541 getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new Tag541();
        }
        return uniqueInstance;
    }

    private void initialize() {
        this.tag = "541";
        this.label = "Immediate Source of Acquisition Note";
        this.bibframeTag = "ImmediateAcquisition";
        this.cardinality = Cardinality.Repeatable;
        this.descriptionUrl = "https://www.loc.gov/marc/bibliographic/bd541.html";
        this.setCompilanceLevels("O");
        this.ind1 = new Indicator("Privacy").setCodes(" ", "No information provided", "0", "Private", "1", "Not private").setMqTag("privacy");
        this.ind2 = new Indicator();
        this.setSubfieldsWithCardinality("a", "Source of acquisition", "NR", "b", "Address", "NR", "c", "Method of acquisition", "NR", "d", "Date of acquisition", "NR", "e", "Accession number", "NR", "f", "Owner", "NR", "h", "Purchase price", "NR", "n", "Extent", "R", "o", "Type of unit", "R", "3", "Materials specified", "NR", "5", "Institution to which field applies", "NR", "6", "Linkage", "NR", "8", "Field link and sequence number", "R");
        this.getSubfield("6").setContentParser(LinkageParser.getInstance());
        this.getSubfield("a").setBibframeTag("rdfs:label").setMqTag("rdf:value").setFrbrFunctions(FRBRFunction.UseManage).setCompilanceLevels("A");
        this.getSubfield("b").setMqTag("address").setFrbrFunctions(FRBRFunction.UseManage).setCompilanceLevels("A");
        this.getSubfield("c").setMqTag("method").setFrbrFunctions(FRBRFunction.UseManage).setCompilanceLevels("A");
        this.getSubfield("d").setMqTag("date").setFrbrFunctions(FRBRFunction.UseManage).setCompilanceLevels("A");
        this.getSubfield("e").setMqTag("accessionNumber").setFrbrFunctions(FRBRFunction.DiscoveryIdentify, FRBRFunction.UseManage).setCompilanceLevels("A");
        this.getSubfield("f").setMqTag("owner").setFrbrFunctions(FRBRFunction.UseManage).setCompilanceLevels("A");
        this.getSubfield("h").setMqTag("price").setFrbrFunctions(FRBRFunction.UseManage).setCompilanceLevels("O");
        this.getSubfield("n").setMqTag("extent").setFrbrFunctions(FRBRFunction.UseManage).setCompilanceLevels("A");
        this.getSubfield("o").setMqTag("typeOfUnit").setFrbrFunctions(FRBRFunction.UseManage).setCompilanceLevels("A");
        this.getSubfield("3").setMqTag("materialsSpecified").setFrbrFunctions(FRBRFunction.DiscoveryIdentify).setCompilanceLevels("O");
        this.getSubfield("5").setMqTag("institutionToWhichFieldApplies").setFrbrFunctions(FRBRFunction.ManagementProcess, FRBRFunction.ManagementDisplay).setCompilanceLevels("A");
        this.getSubfield("6").setBibframeTag("linkage").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("A");
        this.getSubfield("8").setMqTag("fieldLink").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("O");
    }
}

