/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.tags.tags5xx;

import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.FRBRFunction;
import de.gwdg.metadataqa.marc.definition.Indicator;
import de.gwdg.metadataqa.marc.definition.general.codelist.CountryCodes;
import de.gwdg.metadataqa.marc.definition.general.parser.LinkageParser;

public class Tag535
extends DataFieldDefinition {
    private static Tag535 uniqueInstance;

    private Tag535() {
        this.initialize();
        this.postCreation();
    }

    public static Tag535 getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new Tag535();
        }
        return uniqueInstance;
    }

    private void initialize() {
        this.tag = "535";
        this.label = "Location of Originals/Duplicates Note";
        this.mqTag = "LocationOfOriginalsOrDuplicates";
        this.cardinality = Cardinality.Repeatable;
        this.descriptionUrl = "https://www.loc.gov/marc/bibliographic/bd535.html";
        this.setCompilanceLevels("O");
        this.ind1 = new Indicator("Custodial role").setCodes("1", "Holder of originals", "2", "Holder of duplicates").setHistoricalCodes("0", "Repository (AM) [OBSOLETE, 1984]", "3", "Holder of oral tapes (AM) [OBSOLETE, 1984]").setMqTag("custodialRole");
        this.ind2 = new Indicator();
        this.setSubfieldsWithCardinality("a", "Custodian", "NR", "b", "Postal address", "R", "c", "Country", "R", "d", "Telecommunications address", "R", "g", "Repository location code", "NR", "3", "Materials specified", "NR", "6", "Linkage", "NR", "8", "Field link and sequence number", "R");
        this.getSubfield("g").setCodeList(CountryCodes.getInstance());
        this.getSubfield("6").setContentParser(LinkageParser.getInstance());
        this.getSubfield("a").setMqTag("custodian").setFrbrFunctions(FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoveryObtain).setCompilanceLevels("M");
        this.getSubfield("b").setMqTag("postalAddress").setFrbrFunctions(FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoveryObtain).setCompilanceLevels("A");
        this.getSubfield("c").setMqTag("country").setFrbrFunctions(FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoveryObtain).setCompilanceLevels("A");
        this.getSubfield("d").setMqTag("telecommunicationsAddress").setFrbrFunctions(FRBRFunction.DiscoveryObtain).setCompilanceLevels("O");
        this.getSubfield("g").setMqTag("repositoryLocation").setFrbrFunctions(FRBRFunction.DiscoveryObtain).setCompilanceLevels("O");
        this.getSubfield("3").setMqTag("materialsSpecified").setFrbrFunctions(FRBRFunction.DiscoveryIdentify).setCompilanceLevels("O");
        this.getSubfield("6").setBibframeTag("linkage").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("A");
        this.getSubfield("8").setMqTag("fieldLink").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("O");
    }
}

