/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.tags.tags5xx;

import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.FRBRFunction;
import de.gwdg.metadataqa.marc.definition.Indicator;
import de.gwdg.metadataqa.marc.definition.general.parser.LinkageParser;
import de.gwdg.metadataqa.marc.definition.general.validator.ISBNValidator;
import de.gwdg.metadataqa.marc.definition.general.validator.ISSNValidator;

public class Tag534
extends DataFieldDefinition {
    private static Tag534 uniqueInstance;

    private Tag534() {
        this.initialize();
        this.postCreation();
    }

    public static Tag534 getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new Tag534();
        }
        return uniqueInstance;
    }

    private void initialize() {
        this.tag = "534";
        this.label = "Original Version Note";
        this.mqTag = "OriginalVersion";
        this.cardinality = Cardinality.Repeatable;
        this.descriptionUrl = "https://www.loc.gov/marc/bibliographic/bd534.html";
        this.setCompilanceLevels("A");
        this.ind1 = new Indicator().setHistoricalCodes("0", "Note exclude series of original", "1", "Note includes series of original");
        this.ind2 = new Indicator();
        this.setSubfieldsWithCardinality("a", "Main entry of original", "NR", "b", "Edition statement of original", "NR", "c", "Publication, distribution, etc. of original", "NR", "e", "Physical description, etc. of original", "NR", "f", "Series statement of original", "R", "k", "Key title of original", "R", "l", "Location of original", "NR", "m", "Material specific details", "NR", "n", "Note about original", "R", "o", "Other resource identifier", "R", "p", "Introductory phrase", "NR", "t", "Title statement of original", "NR", "x", "International Standard Serial Number", "R", "z", "International Standard Book Number", "R", "3", "Materials specified", "NR", "6", "Linkage", "NR", "8", "Field link and sequence number", "R");
        this.getSubfield("z").setValidator(ISBNValidator.getInstance());
        this.getSubfield("x").setValidator(ISSNValidator.getInstance());
        this.getSubfield("6").setContentParser(LinkageParser.getInstance());
        this.getSubfield("a").setMqTag("mainEntry").setCompilanceLevels("A");
        this.getSubfield("b").setMqTag("edition").setFrbrFunctions(FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoverySelect, FRBRFunction.DiscoveryObtain).setCompilanceLevels("A");
        this.getSubfield("c").setMqTag("publication").setFrbrFunctions(FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoverySelect, FRBRFunction.DiscoveryObtain).setCompilanceLevels("A");
        this.getSubfield("e").setMqTag("physicalDescription").setFrbrFunctions(FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoverySelect, FRBRFunction.DiscoveryObtain).setCompilanceLevels("O");
        this.getSubfield("f").setMqTag("series").setFrbrFunctions(FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoverySelect, FRBRFunction.DiscoveryObtain).setCompilanceLevels("A");
        this.getSubfield("k").setMqTag("keyTitle").setFrbrFunctions(FRBRFunction.DiscoveryIdentify).setCompilanceLevels("A");
        this.getSubfield("l").setMqTag("location").setFrbrFunctions(FRBRFunction.DiscoveryObtain).setCompilanceLevels("O");
        this.getSubfield("m").setMqTag("material").setCompilanceLevels("A");
        this.getSubfield("n").setMqTag("note").setCompilanceLevels("O");
        this.getSubfield("o").setMqTag("otherIdentifier").setCompilanceLevels("O");
        this.getSubfield("p").setMqTag("introductoryPhrase").setFrbrFunctions(FRBRFunction.DiscoveryIdentify).setCompilanceLevels("M");
        this.getSubfield("t").setMqTag("title").setFrbrFunctions(FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoveryObtain).setCompilanceLevels("A");
        this.getSubfield("x").setMqTag("issn").setFrbrFunctions(FRBRFunction.DiscoveryIdentify).setCompilanceLevels("A");
        this.getSubfield("z").setMqTag("isbn").setFrbrFunctions(FRBRFunction.DiscoveryIdentify).setCompilanceLevels("O");
        this.getSubfield("3").setMqTag("materialsSpecified").setCompilanceLevels("O");
        this.getSubfield("6").setBibframeTag("linkage").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("A");
        this.getSubfield("8").setMqTag("fieldLink").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("O");
    }
}

