/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.tags.tags5xx;

import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.FRBRFunction;
import de.gwdg.metadataqa.marc.definition.Indicator;
import de.gwdg.metadataqa.marc.definition.general.parser.LinkageParser;

public class Tag505
extends DataFieldDefinition {
    private static Tag505 uniqueInstance;

    private Tag505() {
        this.initialize();
        this.postCreation();
    }

    public static Tag505 getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new Tag505();
        }
        return uniqueInstance;
    }

    private void initialize() {
        this.tag = "505";
        this.label = "Formatted Contents Note";
        this.bibframeTag = "TableOfContents";
        this.cardinality = Cardinality.Repeatable;
        this.descriptionUrl = "https://www.loc.gov/marc/bibliographic/bd505.html";
        this.setCompilanceLevels("O");
        this.ind1 = new Indicator("Display constant controller").setCodes("0", "Contents", "1", "Incomplete contents", "2", "Partial contents", "8", "No display constant generated").setMqTag("displayConstant").setFrbrFunctions(FRBRFunction.ManagementDisplay);
        this.ind2 = new Indicator("Level of content designation").setCodes(" ", "Basic", "0", "Enhanced").setMqTag("level").setFrbrFunctions(FRBRFunction.ManagementProcess, FRBRFunction.ManagementDisplay);
        this.setSubfieldsWithCardinality("a", "Formatted contents note", "NR", "g", "Miscellaneous information", "R", "r", "Statement of responsibility", "R", "t", "Title", "R", "u", "Uniform Resource Identifier", "R", "6", "Linkage", "NR", "8", "Field link and sequence number", "R");
        this.getSubfield("6").setContentParser(LinkageParser.getInstance());
        this.getSubfield("a").setMqTag("rdf:value").setFrbrFunctions(FRBRFunction.DiscoverySelect).setCompilanceLevels("A");
        this.getSubfield("g").setMqTag("miscellaneous").setFrbrFunctions(FRBRFunction.DiscoverySelect).setCompilanceLevels("A");
        this.getSubfield("r").setMqTag("responsibility").setFrbrFunctions(FRBRFunction.DiscoverySelect).setCompilanceLevels("A");
        this.getSubfield("t").setMqTag("title").setFrbrFunctions(FRBRFunction.DiscoverySelect).setCompilanceLevels("A");
        this.getSubfield("u").setMqTag("uri").setFrbrFunctions(FRBRFunction.DiscoveryObtain).setCompilanceLevels("O");
        this.getSubfield("6").setBibframeTag("linkage").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("A");
        this.getSubfield("8").setMqTag("fieldLink").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("O");
    }
}

