/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.tags.tags5xx;

import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.FRBRFunction;
import de.gwdg.metadataqa.marc.definition.Indicator;
import de.gwdg.metadataqa.marc.definition.general.parser.LinkageParser;

public class Tag502
extends DataFieldDefinition {
    private static Tag502 uniqueInstance;

    private Tag502() {
        this.initialize();
        this.postCreation();
    }

    public static Tag502 getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new Tag502();
        }
        return uniqueInstance;
    }

    private void initialize() {
        this.tag = "502";
        this.label = "Dissertation Note";
        this.bibframeTag = "Dissertation";
        this.cardinality = Cardinality.Repeatable;
        this.descriptionUrl = "https://www.loc.gov/marc/bibliographic/bd502.html";
        this.setCompilanceLevels("O");
        this.ind1 = new Indicator();
        this.ind2 = new Indicator();
        this.setSubfieldsWithCardinality("a", "Dissertation note", "NR", "b", "Degree type", "NR", "c", "Name of granting institution", "NR", "d", "Year degree granted", "NR", "g", "Miscellaneous information", "R", "o", "Dissertation identifier", "R", "6", "Linkage", "NR", "8", "Field link and sequence number", "R");
        this.getSubfield("6").setContentParser(LinkageParser.getInstance());
        this.getSubfield("a").setBibframeTag("rdfs:label").setMqTag("rdf:value").setFrbrFunctions(FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoverySelect, FRBRFunction.DiscoveryObtain).setCompilanceLevels("M");
        this.getSubfield("b").setBibframeTag("degree").setCompilanceLevels("O");
        this.getSubfield("c").setBibframeTag("grantingInstitution").setCompilanceLevels("O");
        this.getSubfield("d").setBibframeTag("date").setCompilanceLevels("O");
        this.getSubfield("g").setBibframeTag("note").setCompilanceLevels("O");
        this.getSubfield("o").setBibframeTag("identifiedBy").setCompilanceLevels("O");
        this.getSubfield("6").setBibframeTag("linkage").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("A");
        this.getSubfield("8").setMqTag("fieldLink").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("O");
    }
}

