/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.tags.tags3xx;

import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.Indicator;
import de.gwdg.metadataqa.marc.definition.general.codelist.ThematicIndexCodeSourceCodes;
import de.gwdg.metadataqa.marc.definition.general.parser.LinkageParser;

public class Tag383
extends DataFieldDefinition {
    private static Tag383 uniqueInstance;

    private Tag383() {
        this.initialize();
        this.postCreation();
    }

    public static Tag383 getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new Tag383();
        }
        return uniqueInstance;
    }

    private void initialize() {
        this.tag = "383";
        this.label = "Numeric Designation of Musical Work";
        this.cardinality = Cardinality.Repeatable;
        this.descriptionUrl = "https://www.loc.gov/marc/bibliographic/bd383.html";
        this.setCompilanceLevels("O");
        this.ind1 = new Indicator();
        this.ind2 = new Indicator();
        this.setSubfieldsWithCardinality("a", "Serial number", "R", "b", "Opus number", "R", "c", "Thematic index number", "R", "d", "Thematic index code", "NR", "e", "Publisher associated with opus number", "NR", "2", "Source", "NR", "6", "Linkage", "NR", "8", "Field link and sequence number", "R");
        this.getSubfield("2").setCodeList(ThematicIndexCodeSourceCodes.getInstance());
        this.getSubfield("6").setContentParser(LinkageParser.getInstance());
        this.getSubfield("a").setMqTag("serialNumber").setCompilanceLevels("A");
        this.getSubfield("b").setMqTag("opusNumber").setCompilanceLevels("M");
        this.getSubfield("c").setMqTag("thematicIndexNumber").setCompilanceLevels("A");
        this.getSubfield("d").setMqTag("thematicIndexCode");
        this.getSubfield("e").setMqTag("publisher");
        this.getSubfield("2").setMqTag("source");
        this.getSubfield("6").setBibframeTag("linkage").setCompilanceLevels("A");
        this.getSubfield("8").setMqTag("fieldLink").setCompilanceLevels("O");
    }
}

