/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.tags.tags3xx;

import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.Indicator;
import de.gwdg.metadataqa.marc.definition.general.codelist.SubjectHeadingAndTermSourceCodes;
import de.gwdg.metadataqa.marc.definition.general.parser.LinkageParser;

public class Tag381
extends DataFieldDefinition {
    private static Tag381 uniqueInstance;

    private Tag381() {
        this.initialize();
        this.postCreation();
    }

    public static Tag381 getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new Tag381();
        }
        return uniqueInstance;
    }

    private void initialize() {
        this.tag = "381";
        this.label = "Other Distinguishing Characteristics of Work or Expression";
        this.mqTag = "OtherDistinguishingCharacteristics";
        this.cardinality = Cardinality.Repeatable;
        this.descriptionUrl = "https://www.loc.gov/marc/bibliographic/bd381.html";
        this.setCompilanceLevels("O");
        this.ind1 = new Indicator();
        this.ind2 = new Indicator();
        this.setSubfieldsWithCardinality("a", "Other distinguishing characteristic", "R", "u", "Uniform Resource Identifier", "R", "v", "Source of information", "R", "0", "Record control number", "R", "2", "Source of term", "NR", "6", "Linkage", "NR", "8", "Field link and sequence number", "R");
        this.getSubfield("2").setCodeList(SubjectHeadingAndTermSourceCodes.getInstance());
        this.getSubfield("6").setContentParser(LinkageParser.getInstance());
        this.getSubfield("a").setMqTag("rdf:value").setCompilanceLevels("M");
        this.getSubfield("u").setMqTag("uri").setCompilanceLevels("A");
        this.getSubfield("v").setMqTag("sourceOfInformation").setCompilanceLevels("A");
        this.getSubfield("0").setMqTag("authorityRecordControlNumber").setCompilanceLevels("A");
        this.getSubfield("2").setMqTag("source").setCompilanceLevels("A");
        this.getSubfield("6").setBibframeTag("linkage").setCompilanceLevels("A");
        this.getSubfield("8").setMqTag("fieldLink").setCompilanceLevels("O");
    }
}

