/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.tags.tags3xx;

import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.Indicator;
import de.gwdg.metadataqa.marc.definition.general.codelist.SubjectHeadingAndTermSourceCodes;
import de.gwdg.metadataqa.marc.definition.general.parser.LinkageParser;

public class Tag370
extends DataFieldDefinition {
    private static Tag370 uniqueInstance;

    private Tag370() {
        this.initialize();
        this.postCreation();
    }

    public static Tag370 getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new Tag370();
        }
        return uniqueInstance;
    }

    private void initialize() {
        this.tag = "370";
        this.label = "Associated Place";
        this.mqTag = "AssociatedPlace";
        this.cardinality = Cardinality.Repeatable;
        this.descriptionUrl = "https://www.loc.gov/marc/bibliographic/bd370.html";
        this.ind1 = new Indicator();
        this.ind2 = new Indicator();
        this.setSubfieldsWithCardinality("c", "Associated country", "R", "f", "Other associated place", "R", "g", "Place of origin of work or expression", "R", "i", "Relationship information", "R", "s", "Start period", "NR", "t", "End period", "NR", "u", "Uniform Resource Identifier", "R", "v", "Source of information", "R", "0", "Authority record control number or standard number", "R", "2", "Source of term", "NR", "3", "Materials specified", "NR", "4", "Relationship", "R", "6", "Linkage", "NR", "8", "Field link and sequence number", "R");
        this.getSubfield("2").setCodeList(SubjectHeadingAndTermSourceCodes.getInstance());
        this.getSubfield("6").setContentParser(LinkageParser.getInstance());
        this.getSubfield("c").setMqTag("country");
        this.getSubfield("f").setMqTag("otherPlace");
        this.getSubfield("g").setMqTag("placeOfOrigin");
        this.getSubfield("i").setMqTag("relationship");
        this.getSubfield("s").setMqTag("startPeriod");
        this.getSubfield("t").setMqTag("endPeriod");
        this.getSubfield("u").setMqTag("uri");
        this.getSubfield("v").setMqTag("sourceOfInformation");
        this.getSubfield("0").setMqTag("authorityRecordControlNumber");
        this.getSubfield("2").setMqTag("source");
        this.getSubfield("3").setMqTag("materialsSpecified");
        this.getSubfield("4").setMqTag("relationship");
        this.getSubfield("6").setBibframeTag("linkage");
        this.getSubfield("8").setMqTag("fieldLink");
    }
}

