/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.tags.tags3xx;

import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.FRBRFunction;
import de.gwdg.metadataqa.marc.definition.Indicator;
import de.gwdg.metadataqa.marc.definition.general.parser.LinkageParser;

public class Tag357
extends DataFieldDefinition {
    private static Tag357 uniqueInstance;

    private Tag357() {
        this.initialize();
        this.postCreation();
    }

    public static Tag357 getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new Tag357();
        }
        return uniqueInstance;
    }

    private void initialize() {
        this.tag = "357";
        this.label = "Originator Dissemination Control";
        this.mqTag = "OriginatorDisseminationControl";
        this.cardinality = Cardinality.Nonrepeatable;
        this.descriptionUrl = "https://www.loc.gov/marc/bibliographic/bd357.html";
        this.setCompilanceLevels("A");
        this.ind1 = new Indicator();
        this.ind2 = new Indicator();
        this.setSubfieldsWithCardinality("a", "Originator control term", "NR", "b", "Originating agency", "R", "c", "Authorized recipients of material", "R", "g", "Other restrictions", "R", "6", "Linkage", "NR", "8", "Field link and sequence number", "R");
        this.getSubfield("6").setContentParser(LinkageParser.getInstance());
        this.getSubfield("a").setMqTag("rdf:value").setFrbrFunctions(FRBRFunction.UseRestrict).setCompilanceLevels("M");
        this.getSubfield("b").setMqTag("originatingAgency").setFrbrFunctions(FRBRFunction.UseRestrict).setCompilanceLevels("M");
        this.getSubfield("c").setMqTag("authorizedRecipients").setFrbrFunctions(FRBRFunction.UseRestrict).setCompilanceLevels("A");
        this.getSubfield("g").setMqTag("otherRestrictions").setFrbrFunctions(FRBRFunction.UseRestrict).setCompilanceLevels("A");
        this.getSubfield("6").setBibframeTag("linkage").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("A");
        this.getSubfield("8").setMqTag("fieldLink").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("O");
    }
}

