/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.tags.tags3xx;

import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.FRBRFunction;
import de.gwdg.metadataqa.marc.definition.Indicator;
import de.gwdg.metadataqa.marc.definition.general.codelist.CountryCodes;
import de.gwdg.metadataqa.marc.definition.general.codelist.OrganizationCodes;
import de.gwdg.metadataqa.marc.definition.general.parser.LinkageParser;

public class Tag355
extends DataFieldDefinition {
    private static Tag355 uniqueInstance;

    private Tag355() {
        this.initialize();
        this.postCreation();
    }

    public static Tag355 getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new Tag355();
        }
        return uniqueInstance;
    }

    private void initialize() {
        this.tag = "355";
        this.label = "Security Classification Control";
        this.mqTag = "SecurityClassificationControl";
        this.cardinality = Cardinality.Repeatable;
        this.descriptionUrl = "https://www.loc.gov/marc/bibliographic/bd355.html";
        this.setCompilanceLevels("A");
        this.ind1 = new Indicator("Controlled element").setCodes("0", "Document", "1", "Title", "2", "Abstract", "3", "Contents note", "4", "Author", "5", "Record", "8", "None of the above").setMqTag("controlledElement").setFrbrFunctions(FRBRFunction.DiscoveryIdentify);
        this.ind2 = new Indicator();
        this.setSubfieldsWithCardinality("a", "Security classification", "NR", "b", "Handling instructions", "R", "c", "External dissemination information", "R", "d", "Downgrading or declassification event", "NR", "e", "Classification system", "NR", "f", "Country of origin code", "NR", "g", "Downgrading date", "NR", "h", "Declassification date", "NR", "j", "Authorization", "R", "6", "Linkage", "NR", "8", "Field link and sequence number", "R");
        this.getSubfield("f").setCodeList(CountryCodes.getInstance());
        this.getSubfield("j").setCodeList(OrganizationCodes.getInstance());
        this.getSubfield("6").setContentParser(LinkageParser.getInstance());
        this.getSubfield("a").setMqTag("rdf:value").setFrbrFunctions(FRBRFunction.UseRestrict).setCompilanceLevels("M");
        this.getSubfield("b").setMqTag("handlingInstructions").setFrbrFunctions(FRBRFunction.UseRestrict).setCompilanceLevels("A");
        this.getSubfield("c").setMqTag("externalDissemination").setFrbrFunctions(FRBRFunction.UseRestrict).setCompilanceLevels("A");
        this.getSubfield("d").setMqTag("downgradingEvent").setFrbrFunctions(FRBRFunction.UseRestrict).setCompilanceLevels("A");
        this.getSubfield("e").setMqTag("classificationSystem").setFrbrFunctions(FRBRFunction.UseRestrict).setCompilanceLevels("A");
        this.getSubfield("f").setMqTag("countryOfOrigin").setFrbrFunctions(FRBRFunction.UseRestrict).setCompilanceLevels("A");
        this.getSubfield("g").setMqTag("downgradingDate").setFrbrFunctions(FRBRFunction.UseRestrict).setCompilanceLevels("A");
        this.getSubfield("h").setMqTag("declassificationDate").setFrbrFunctions(FRBRFunction.UseRestrict).setCompilanceLevels("A");
        this.getSubfield("j").setBibframeTag("authorization").setFrbrFunctions(FRBRFunction.UseRestrict).setCompilanceLevels("A");
        this.getSubfield("6").setBibframeTag("linkage").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("A");
        this.getSubfield("8").setMqTag("fieldLink").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("O");
    }
}

