/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.tags.tags3xx;

import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.Indicator;
import de.gwdg.metadataqa.marc.definition.general.parser.LinkageParser;

public class Tag344
extends DataFieldDefinition {
    private static Tag344 uniqueInstance;

    private Tag344() {
        this.initialize();
        this.postCreation();
    }

    public static Tag344 getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new Tag344();
        }
        return uniqueInstance;
    }

    private void initialize() {
        this.tag = "344";
        this.label = "Sound Characteristics";
        this.bibframeTag = "SoundCharacteristic";
        this.cardinality = Cardinality.Repeatable;
        this.descriptionUrl = "https://www.loc.gov/marc/bibliographic/bd344.html";
        this.ind1 = new Indicator();
        this.ind2 = new Indicator();
        this.setSubfieldsWithCardinality("a", "Type of recording", "R", "b", "Recording medium", "R", "c", "Playing speed", "R", "d", "Groove characteristic", "R", "e", "Track configuration", "R", "f", "Tape configuration", "R", "g", "Configuration of playback channels", "R", "h", "Special playback characteristics", "R", "0", "Authority record control number or standard number", "R", "2", "Source", "NR", "3", "Materials specified", "NR", "6", "Linkage", "NR", "8", "Field link and sequence number", "R");
        this.getSubfield("6").setContentParser(LinkageParser.getInstance());
        this.getSubfield("a").setBibframeTag("recordingMethod");
        this.getSubfield("b").setBibframeTag("recordingMedium");
        this.getSubfield("c").setBibframeTag("playingSpeed");
        this.getSubfield("d").setBibframeTag("grooveCharacteristics");
        this.getSubfield("e").setBibframeTag("trackConfig");
        this.getSubfield("f").setBibframeTag("tapeConfig");
        this.getSubfield("g").setBibframeTag("playbackChannels");
        this.getSubfield("h").setBibframeTag("playbackCharacteristic");
        this.getSubfield("0").setMqTag("authorityRecordControlNumber");
        this.getSubfield("2").setBibframeTag("source");
        this.getSubfield("3").setMqTag("materialsSpecified");
        this.getSubfield("6").setBibframeTag("linkage");
        this.getSubfield("8").setMqTag("fieldLink");
    }
}

