/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.tags.tags3xx;

import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.FRBRFunction;
import de.gwdg.metadataqa.marc.definition.Indicator;
import de.gwdg.metadataqa.marc.definition.general.parser.LinkageParser;

public class Tag300
extends DataFieldDefinition {
    private static Tag300 uniqueInstance;

    private Tag300() {
        this.initialize();
        this.postCreation();
    }

    public static Tag300 getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new Tag300();
        }
        return uniqueInstance;
    }

    private void initialize() {
        this.tag = "300";
        this.label = "Physical Description";
        this.mqTag = "PhysicalDescription";
        this.cardinality = Cardinality.Repeatable;
        this.descriptionUrl = "https://www.loc.gov/marc/bibliographic/bd300.html";
        this.setCompilanceLevels("M", "M");
        this.ind1 = new Indicator();
        this.ind2 = new Indicator();
        this.setSubfieldsWithCardinality("a", "Extent", "R", "b", "Other physical details", "NR", "c", "Dimensions", "R", "e", "Accompanying material", "NR", "f", "Type of unit", "R", "g", "Size of unit", "R", "3", "Materials specified", "NR", "6", "Linkage", "NR", "8", "Field link and sequence number", "R");
        this.getSubfield("6").setContentParser(LinkageParser.getInstance());
        this.getSubfield("a").setBibframeTag("extent").setFrbrFunctions(FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoverySelect).setCompilanceLevels("M", "M");
        this.getSubfield("b").setBibframeTag("note").setMqTag("otherPhysicalDetails").setFrbrFunctions(FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoverySelect, FRBRFunction.DiscoveryObtain, FRBRFunction.UseManage, FRBRFunction.UseOperate).setCompilanceLevels("A");
        this.getSubfield("c").setBibframeTag("dimensions").setFrbrFunctions(FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoverySelect, FRBRFunction.DiscoveryObtain, FRBRFunction.UseOperate).setCompilanceLevels("M");
        this.getSubfield("e").setBibframeTag("note").setMqTag("accompanyingMaterial").setFrbrFunctions(FRBRFunction.DiscoverySelect).setCompilanceLevels("A");
        this.getSubfield("f").setMqTag("typeOfUnit").setFrbrFunctions(FRBRFunction.UseManage, FRBRFunction.UseOperate).setCompilanceLevels("A", "A");
        this.getSubfield("g").setMqTag("sizeOfUnit").setFrbrFunctions(FRBRFunction.UseManage, FRBRFunction.UseOperate).setCompilanceLevels("A");
        this.getSubfield("3").setMqTag("materialsSpecified").setFrbrFunctions(FRBRFunction.DiscoveryIdentify).setCompilanceLevels("O");
        this.getSubfield("6").setMqTag("linkage").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("A", "A");
        this.getSubfield("8").setMqTag("fieldLink").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("O");
        this.setHistoricalSubfields("d", "Accompanying material [OBSOLETE, 1997] [CAN/MARC only]", "m", "Identification/manufacturer number [pre-AACR2 records only] [OBSOLETE, 1988] [CAN/MARC only]", "n", "Matrix and/or take number [Sound recordings, pre-AACR2 records only] [OBSOLETE, 1988] [CAN/MARC only]");
    }
}

