/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.tags.tags25x;

import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.Indicator;
import de.gwdg.metadataqa.marc.definition.general.parser.LinkageParser;

public class Tag264
extends DataFieldDefinition {
    private static Tag264 uniqueInstance;

    private Tag264() {
        this.initialize();
        this.postCreation();
    }

    public static Tag264 getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new Tag264();
        }
        return uniqueInstance;
    }

    private void initialize() {
        this.tag = "264";
        this.label = "Production, Publication, Distribution, Manufacture, and Copyright Notice";
        this.mqTag = "ProvisionActivity";
        this.cardinality = Cardinality.Repeatable;
        this.descriptionUrl = "https://www.loc.gov/marc/bibliographic/bd264.html";
        this.ind1 = new Indicator("Sequence of statements").setCodes(" ", "Not applicable/No information provided/Earliest", "2", "Intervening", "3", "Current/Latest").setMqTag("sequenceOfStatements");
        this.ind2 = new Indicator("Function of entity").setCodes("0", "Production", "1", "Publication", "2", "Distribution", "3", "Manufacture", "4", "Copyright notice date").setMqTag("function");
        this.setSubfieldsWithCardinality("a", "Place of production, publication, distribution, manufacture", "R", "b", "Name of producer, publisher, distributor, manufacturer", "R", "c", "Date of production, publication, distribution, manufacture, or copyright notice", "R", "3", "Materials specified", "NR", "6", "Linkage", "NR", "8", "Field link and sequence number", "R");
        this.getSubfield("6").setContentParser(LinkageParser.getInstance());
        this.getSubfield("a").setBibframeTag("place");
        this.getSubfield("b").setBibframeTag("agent");
        this.getSubfield("c").setBibframeTag("date");
        this.getSubfield("3").setMqTag("materialsSpecified");
        this.getSubfield("6").setMqTag("linkage");
        this.getSubfield("8").setMqTag("fieldLink");
    }
}

