/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.tags.tags20x;

import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.FRBRFunction;
import de.gwdg.metadataqa.marc.definition.Indicator;
import de.gwdg.metadataqa.marc.definition.general.parser.LinkageParser;
import de.gwdg.metadataqa.marc.definition.general.validator.ISSNValidator;

public class Tag247
extends DataFieldDefinition {
    private static Tag247 uniqueInstance;

    private Tag247() {
        this.initialize();
        this.postCreation();
    }

    public static Tag247 getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new Tag247();
        }
        return uniqueInstance;
    }

    private void initialize() {
        this.tag = "247";
        this.label = "Former Title";
        this.bibframeTag = "VariantTitle";
        this.cardinality = Cardinality.Repeatable;
        this.descriptionUrl = "https://www.loc.gov/marc/bibliographic/bd247.html";
        this.setCompilanceLevels("A");
        this.ind1 = new Indicator("Title added entry").setCodes("0", "No added entry", "1", "Added entry").setMqTag("titleAddedEntry").setFrbrFunctions(FRBRFunction.ManagementProcess, FRBRFunction.ManagementDisplay);
        this.ind2 = new Indicator("Note controller").setCodes("0", "Display note", "1", "Do not display note").setMqTag("noteController").setFrbrFunctions(FRBRFunction.ManagementProcess, FRBRFunction.ManagementDisplay);
        this.setSubfieldsWithCardinality("a", "Title", "NR", "b", "Remainder of title", "NR", "f", "Date or sequential designation", "NR", "g", "Miscellaneous information", "R", "h", "Medium", "NR", "n", "Number of part/section of a work", "R", "p", "Name of part/section of a work", "R", "x", "International Standard Serial Number", "NR", "6", "Linkage", "NR", "8", "Field link and sequence number", "R");
        this.getSubfield("6").setContentParser(LinkageParser.getInstance());
        this.getSubfield("x").setValidator(ISSNValidator.getInstance());
        this.getSubfield("a").setBibframeTag("mainTitle").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoveryObtain).setCompilanceLevels("M");
        this.getSubfield("b").setMqTag("remainder").setCompilanceLevels("A");
        this.getSubfield("f").setBibframeTag("date").setCompilanceLevels("A");
        this.getSubfield("g").setBibframeTag("qualifier").setMqTag("miscellaneous").setCompilanceLevels("A");
        this.getSubfield("h").setMqTag("medium").setFrbrFunctions(FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoverySelect, FRBRFunction.DiscoveryObtain).setCompilanceLevels("A");
        this.getSubfield("n").setBibframeTag("partNumber").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoveryObtain).setCompilanceLevels("A");
        this.getSubfield("p").setBibframeTag("partName").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoveryObtain).setCompilanceLevels("A");
        this.getSubfield("x").setMqTag("issn").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoveryObtain).setCompilanceLevels("A");
        this.getSubfield("6").setBibframeTag("linkage").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("A");
        this.getSubfield("8").setMqTag("fieldLink").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("O");
        this.setHistoricalSubfields("d", "Designation of section/part/series (SE) [OBSOLETE, 1979]", "e", "Name of section/part/series (SE) [OBSOLETE, 1979]", "c", "Remainder of Title Page transcription [OBSOLETE] [CAN/MARC only]");
    }
}

