/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.tags.tags20x;

import de.gwdg.metadataqa.marc.Code;
import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.FRBRFunction;
import de.gwdg.metadataqa.marc.definition.Indicator;
import de.gwdg.metadataqa.marc.definition.MarcVersion;
import de.gwdg.metadataqa.marc.definition.general.codelist.OrganizationCodes;
import de.gwdg.metadataqa.marc.definition.general.parser.LinkageParser;
import java.util.Arrays;

public class Tag246
extends DataFieldDefinition {
    private static Tag246 uniqueInstance;

    private Tag246() {
        this.initialize();
        this.postCreation();
    }

    public static Tag246 getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new Tag246();
        }
        return uniqueInstance;
    }

    private void initialize() {
        this.tag = "246";
        this.label = "Varying Form of Title";
        this.bibframeTag = "ParallelTitle";
        this.cardinality = Cardinality.Repeatable;
        this.descriptionUrl = "https://www.loc.gov/marc/bibliographic/bd246.html";
        this.setCompilanceLevels("A", "A");
        this.ind1 = new Indicator("Note/added entry controller").setCodes("0", "Note, no added entry", "1", "Note, added entry", "2", "No note, no added entry", "3", "No note, added entry").putVersionSpecificCodes(MarcVersion.SZTE, Arrays.asList(new Code(" ", "Not specified"))).setMqTag("noteAndAddedEntry").setFrbrFunctions(FRBRFunction.ManagementProcess, FRBRFunction.ManagementDisplay);
        this.ind2 = new Indicator("Type of title").setCodes(" ", "No type specified", "0", "Portion of title", "1", "Parallel title", "2", "Distinctive title", "3", "Other title", "4", "Cover title", "5", "Added title page title", "6", "Caption title", "7", "Running title", "8", "Spine title").putVersionSpecificCodes(MarcVersion.DNB, Arrays.asList(new Code("9", "Ansetzungstitel"))).setMqTag("type").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess, FRBRFunction.ManagementSort);
        this.setSubfieldsWithCardinality("a", "Title proper/short title", "NR", "b", "Remainder of title", "NR", "f", "Date or sequential designation", "NR", "g", "Miscellaneous information", "R", "h", "Medium", "NR", "i", "Display text", "NR", "n", "Number of part/section of a work", "R", "p", "Name of part/section of a work", "R", "5", "Institution to which field applies", "NR", "6", "Linkage", "NR", "8", "Field link and sequence number", "R");
        this.getSubfield("5").setCodeList(OrganizationCodes.getInstance());
        this.getSubfield("6").setContentParser(LinkageParser.getInstance());
        this.getSubfield("a").setBibframeTag("mainTitle").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoveryObtain).setCompilanceLevels("M", "M");
        this.getSubfield("b").setBibframeTag("subtitle").setCompilanceLevels("A");
        this.getSubfield("f").setBibframeTag("date").setCompilanceLevels("A", "A");
        this.getSubfield("g").setBibframeTag("miscellaneous").setCompilanceLevels("A");
        this.getSubfield("h").setMqTag("medium").setFrbrFunctions(FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoverySelect, FRBRFunction.DiscoveryObtain).setCompilanceLevels("O");
        this.getSubfield("i").setMqTag("displayText").setCompilanceLevels("A");
        this.getSubfield("n").setBibframeTag("partNumber").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoveryObtain).setCompilanceLevels("A", "A");
        this.getSubfield("p").setBibframeTag("partName").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoveryObtain).setCompilanceLevels("A", "A");
        this.getSubfield("5").setMqTag("institutionToWhichFieldApplies").setFrbrFunctions(FRBRFunction.ManagementProcess, FRBRFunction.ManagementDisplay).setCompilanceLevels("A");
        this.getSubfield("6").setBibframeTag("linkage").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("A", "A");
        this.getSubfield("8").setMqTag("fieldLink").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("O");
        this.setHistoricalSubfields("c", "Remainder of title page transcription [OBSOLETE, 1991] [CAN/MARC only]", "d", "Designation of section/part/series (SE) [OBSOLETE, 1979]", "e", "Name of section/part/series (SE) [OBSOLETE, 1979]");
    }
}

