/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.tags.tags20x;

import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.FRBRFunction;
import de.gwdg.metadataqa.marc.definition.Indicator;
import de.gwdg.metadataqa.marc.definition.general.codelist.LanguageCodes;
import de.gwdg.metadataqa.marc.definition.general.parser.LinkageParser;

public class Tag242
extends DataFieldDefinition {
    private static Tag242 uniqueInstance;

    private Tag242() {
        this.initialize();
        this.postCreation();
    }

    public static Tag242 getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new Tag242();
        }
        return uniqueInstance;
    }

    private void initialize() {
        this.tag = "242";
        this.label = "Translation of Title by Cataloging Agency";
        this.bibframeTag = "VariantTitle";
        this.mqTag = "TitleTranslation";
        this.cardinality = Cardinality.Repeatable;
        this.descriptionUrl = "https://www.loc.gov/marc/bibliographic/bd242.html";
        this.setCompilanceLevels("O");
        this.ind1 = new Indicator("Title added entry").setCodes("0", "No added entry", "1", "Added entry").setMqTag("titleAddedEntry").setFrbrFunctions(FRBRFunction.ManagementProcess, FRBRFunction.ManagementDisplay);
        this.ind2 = new Indicator("Nonfiling characters").setCodes("0", "No nonfiling characters", "1-9", "Number of nonfiling characters").setMqTag("nonfilingCharacters").setFrbrFunctions(FRBRFunction.ManagementProcess, FRBRFunction.ManagementSort);
        this.ind2.getCode("1-9").setRange(true);
        this.setSubfieldsWithCardinality("a", "Title", "NR", "b", "Remainder of title", "NR", "c", "Statement of responsibility, etc.", "NR", "h", "Medium", "NR", "n", "Number of part/section of a work", "R", "p", "Name of part/section of a work", "R", "y", "Language code of translated title", "NR", "6", "Linkage", "NR", "8", "Field link and sequence number", "R");
        this.getSubfield("y").setCodeList(LanguageCodes.getInstance());
        this.getSubfield("6").setContentParser(LinkageParser.getInstance());
        this.getSubfield("a").setBibframeTag("mainTitle").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify).setCompilanceLevels("M");
        this.getSubfield("b").setBibframeTag("subTitle").setCompilanceLevels("O");
        this.getSubfield("c").setMqTag("responsibility").setFrbrFunctions(FRBRFunction.DiscoveryIdentify).setCompilanceLevels("O");
        this.getSubfield("h").setMqTag("medium").setFrbrFunctions(FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoverySelect).setCompilanceLevels("O");
        this.getSubfield("n").setBibframeTag("partNumber").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify).setCompilanceLevels("A");
        this.getSubfield("p").setBibframeTag("partName").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify).setCompilanceLevels("A");
        this.getSubfield("y").setBibframeTag("language").setFrbrFunctions(FRBRFunction.ManagementProcess).setCompilanceLevels("M");
        this.getSubfield("6").setBibframeTag("linkage").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("A");
        this.getSubfield("8").setMqTag("fieldLink").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("O");
        this.setHistoricalSubfields("d", "Designation of section (BK, AM, MP, MU, VM, SE) [OBSOLETE, 1979]", "e", "Name of part/section (BK, AM, MP, MU, VM, SE) [OBSOLETE, 1979]");
    }
}

