/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.tags.tags20x;

import de.gwdg.metadataqa.marc.Code;
import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.FRBRFunction;
import de.gwdg.metadataqa.marc.definition.Indicator;
import de.gwdg.metadataqa.marc.definition.MarcVersion;
import de.gwdg.metadataqa.marc.definition.general.parser.LinkageParser;
import java.util.Arrays;

public class Tag240
extends DataFieldDefinition {
    private static Tag240 uniqueInstance;

    private Tag240() {
        this.initialize();
        this.postCreation();
    }

    public static Tag240 getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new Tag240();
        }
        return uniqueInstance;
    }

    private void initialize() {
        this.tag = "240";
        this.label = "Uniform Title";
        this.mqTag = "UniformTitle";
        this.cardinality = Cardinality.Nonrepeatable;
        this.descriptionUrl = "https://www.loc.gov/marc/bibliographic/bd240.html";
        this.setCompilanceLevels("A", "A");
        this.ind1 = new Indicator("Uniform title printed or displayed").setCodes("0", "Not printed or displayed", "1", "Printed or displayed").putVersionSpecificCodes(MarcVersion.SZTE, Arrays.asList(new Code(" ", "Not specified"))).setHistoricalCodes("2", "Not printed on card, title added entry (MU) [OBSOLETE, 1993]", "3", "Printed on card, title added entry (MU) [OBSOLETE, 1993]").setMqTag("printedOrDisplayed").setFrbrFunctions(FRBRFunction.ManagementProcess, FRBRFunction.ManagementDisplay);
        this.ind2 = new Indicator("Nonfiling characters").setCodes("0-9", "Number of nonfiling characters").setMqTag("nonfilingCharacters").setFrbrFunctions(FRBRFunction.ManagementProcess, FRBRFunction.ManagementSort);
        this.ind2.getCode("0-9").setRange(true);
        this.setSubfieldsWithCardinality("a", "Uniform title", "NR", "d", "Date of treaty signing", "R", "f", "Date of a work", "NR", "g", "Miscellaneous information", "R", "h", "Medium", "NR", "k", "Form subheading", "R", "l", "Language of a work", "NR", "m", "Medium of performance for music", "R", "n", "Number of part/section of a work", "R", "o", "Arranged statement for music", "NR", "p", "Name of part/section of a work", "R", "r", "Key for music", "NR", "s", "Version", "NR", "0", "Authority record control number or standard number", "R", "6", "Linkage", "NR", "8", "Field link and sequence number", "R");
        this.getSubfield("6").setContentParser(LinkageParser.getInstance());
        this.getSubfield("a").setBibframeTag("mainTitle").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify).setCompilanceLevels("M", "M");
        this.getSubfield("d").setMqTag("dateOfTreaty").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify).setCompilanceLevels("A", "A");
        this.getSubfield("f").setMqTag("dateOfAWork").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify).setCompilanceLevels("A", "A");
        this.getSubfield("g").setMqTag("miscellaneous").setCompilanceLevels("A", "A");
        this.getSubfield("h").setMqTag("medium").setFrbrFunctions(FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoverySelect).setCompilanceLevels("O");
        this.getSubfield("k").setMqTag("formSubheading").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoverySelect).setCompilanceLevels("A", "A");
        this.getSubfield("l").setMqTag("languageOfAWork").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoverySelect).setCompilanceLevels("A", "A");
        this.getSubfield("m").setMqTag("mediumOfPerformance").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoverySelect).setCompilanceLevels("A", "A");
        this.getSubfield("n").setBibframeTag("partNumber").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify).setCompilanceLevels("A", "A");
        this.getSubfield("o").setMqTag("arrangedStatement").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify).setCompilanceLevels("A", "A");
        this.getSubfield("p").setMqTag("nameOfPart").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify).setCompilanceLevels("A", "A");
        this.getSubfield("r").setMqTag("keyForMusic").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify).setCompilanceLevels("A", "A");
        this.getSubfield("s").setBibframeTag("version").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoverySelect).setCompilanceLevels("A", "A");
        this.getSubfield("0").setMqTag("authorityRecordControlNumber").setCompilanceLevels("O");
        this.getSubfield("6").setBibframeTag("linkage").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("A", "A");
        this.getSubfield("8").setMqTag("fieldLink").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("O");
    }
}

