/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.tags.tags20x;

import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.FRBRFunction;
import de.gwdg.metadataqa.marc.definition.Indicator;
import de.gwdg.metadataqa.marc.definition.general.codelist.AbbreviatedTitleSourceCodes;
import de.gwdg.metadataqa.marc.definition.general.parser.LinkageParser;

public class Tag210
extends DataFieldDefinition {
    private static Tag210 uniqueInstance;

    private Tag210() {
        this.initialize();
        this.postCreation();
    }

    public static Tag210 getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new Tag210();
        }
        return uniqueInstance;
    }

    private void initialize() {
        this.tag = "210";
        this.label = "Abbreviated Title";
        this.bibframeTag = "AbbreviatedTitle";
        this.cardinality = Cardinality.Repeatable;
        this.descriptionUrl = "https://www.loc.gov/marc/bibliographic/bd210.html";
        this.setCompilanceLevels("O");
        this.ind1 = new Indicator("Title added entry").setCodes("0", "No added entry", "1", "Added entry").setMqTag("titleAddedEntry").setFrbrFunctions(FRBRFunction.ManagementProcess, FRBRFunction.ManagementDisplay);
        this.ind2 = new Indicator("Type").setCodes(" ", "Abbreviated key title", "0", "Other abbreviated title").setMqTag("type").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess, FRBRFunction.ManagementSort);
        this.setSubfieldsWithCardinality("a", "Abbreviated title", "NR", "b", "Qualifying information", "NR", "2", "Source", "R", "6", "Linkage", "NR", "8", "Field link and sequence number", "R");
        this.getSubfield("2").setCodeList(AbbreviatedTitleSourceCodes.getInstance());
        this.getSubfield("6").setContentParser(LinkageParser.getInstance());
        this.getSubfield("a").setBibframeTag("mainTitle").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoveryObtain).setCompilanceLevels("A");
        this.getSubfield("b").setBibframeTag("qualifier").setCompilanceLevels("A");
        this.getSubfield("2").setBibframeTag("source").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("A");
        this.getSubfield("6").setBibframeTag("linkage").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("A");
        this.getSubfield("8").setMqTag("fieldLink").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("O");
    }
}

