/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.tags.tags01x;

import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.FRBRFunction;
import de.gwdg.metadataqa.marc.definition.Indicator;

public class Tag071
extends DataFieldDefinition {
    private static Tag071 uniqueInstance;

    private Tag071() {
        this.initialize();
        this.postCreation();
    }

    public static Tag071 getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new Tag071();
        }
        return uniqueInstance;
    }

    private void initialize() {
        this.tag = "071";
        this.label = "National Agricultural Library Copy Statement";
        this.mqTag = "NalCopy";
        this.cardinality = Cardinality.Repeatable;
        this.descriptionUrl = "https://www.loc.gov/marc/bibliographic/bd071.html";
        this.setCompilanceLevels("O");
        this.ind1 = new Indicator();
        this.ind2 = new Indicator().setHistoricalCodes("0", "No series involved", "1", "Main series", "2", "Subseries", "3", "Sub-subseries");
        this.setSubfieldsWithCardinality("a", "Classification number", "R", "b", "Item number", "NR", "c", "Copy information", "R", "8", "Field link and sequence number", "R");
        this.getSubfield("a").setBibframeTag("classificationPortion").setMqTag("classification").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoveryObtain).setCompilanceLevels("M");
        this.getSubfield("b").setBibframeTag("itemPortion").setMqTag("item").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoveryObtain).setCompilanceLevels("A");
        this.getSubfield("c").setMqTag("copy").setCompilanceLevels("A");
        this.getSubfield("8").setMqTag("fieldLink").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("O");
    }
}

