/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.tags.tags01x;

import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.FRBRFunction;
import de.gwdg.metadataqa.marc.definition.Indicator;

public class Tag060
extends DataFieldDefinition {
    private static Tag060 uniqueInstance;

    private Tag060() {
        this.initialize();
        this.postCreation();
    }

    public static Tag060 getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new Tag060();
        }
        return uniqueInstance;
    }

    private void initialize() {
        this.tag = "060";
        this.label = "National Library of Medicine Call Number";
        this.bibframeTag = "ClassificationNlm";
        this.cardinality = Cardinality.Repeatable;
        this.descriptionUrl = "https://www.loc.gov/marc/bibliographic/bd060.html";
        this.setCompilanceLevels("O");
        this.ind1 = new Indicator("Existence in NLM collection").setCodes(" ", "No information provided", "0", "Item is in NLM", "1", "Item is not in NLM").setMqTag("existenceInNLM").setFrbrFunctions(FRBRFunction.DiscoverySelect, FRBRFunction.DiscoveryObtain);
        this.ind2 = new Indicator("Source of call number").setCodes("0", "Assigned by NLM", "4", "Assigned by agency other than NLM").setHistoricalCodes("0", "No series involved", "1", "Main series", "2", "Subseries", "3", "Sub-subseries", " ", "No information provided [OBSOLETE]").setMqTag("source").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess);
        this.setSubfieldsWithCardinality("a", "Classification number", "R", "b", "Item number", "NR", "0", "Authority record control number or standard number", "R", "8", "Field link and sequence number", "R");
        this.getSubfield("a").setBibframeTag("classificationPortion").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoveryObtain).setCompilanceLevels("M");
        this.getSubfield("b").setBibframeTag("itemPortion").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoveryObtain).setCompilanceLevels("A");
        this.getSubfield("0").setMqTag("authorityRecordControlNumber");
        this.getSubfield("8").setMqTag("fieldLink").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("O");
    }
}

