/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.tags.tags01x;

import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.FRBRFunction;
import de.gwdg.metadataqa.marc.definition.Indicator;
import de.gwdg.metadataqa.marc.definition.SourceSpecificationType;
import de.gwdg.metadataqa.marc.definition.general.codelist.ClassificationSchemeSourceCodes;
import de.gwdg.metadataqa.marc.definition.general.parser.LinkageParser;

public class Tag055
extends DataFieldDefinition {
    private static Tag055 uniqueInstance;

    private Tag055() {
        this.initialize();
        this.postCreation();
    }

    public static Tag055 getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new Tag055();
        }
        return uniqueInstance;
    }

    private void initialize() {
        this.tag = "055";
        this.label = "Classification Numbers Assigned in Canada";
        this.bibframeTag = "ClassificationLcc";
        this.cardinality = Cardinality.Repeatable;
        this.descriptionUrl = "https://www.loc.gov/marc/bibliographic/bd055.html";
        this.setCompilanceLevels("O");
        this.ind1 = new Indicator("Existence in LAC collection").setCodes(" ", "Information not provided", "0", "Work held by LAC", "1", "Work not held by LAC").setMqTag("heldByLAC").setFrbrFunctions(FRBRFunction.DiscoverySelect, FRBRFunction.DiscoveryObtain);
        this.ind2 = new Indicator("Type, completeness, source of class/call number").setCodes("0", "LC-based call number assigned by LAC", "1", "Complete LC class number assigned by LAC", "2", "Incomplete LC class number assigned by LAC", "3", "LC-based call number assigned by the contributing library", "4", "Complete LC class number assigned by the contributing library", "5", "Incomplete LC class number assigned by the contributing library", "6", "Other call number assigned by LAC", "7", "Other class number assigned by LAC", "8", "Other call number assigned by the contributing library", "9", "Other class number assigned by the contributing library").setMqTag("type").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess);
        this.setSubfieldsWithCardinality("a", "Classification number", "NR", "b", "Item number", "NR", "0", "Authority record control number or standard number", "R", "2", "Source of call/class number", "NR", "6", "Linkage", "NR", "8", "Field link and sequence number", "R");
        this.getSubfield("2").setCodeList(ClassificationSchemeSourceCodes.getInstance());
        this.getSubfield("6").setContentParser(LinkageParser.getInstance());
        this.getSubfield("a").setBibframeTag("classificationPortion").setMqTag("rdf:value").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoveryObtain).setCompilanceLevels("M");
        this.getSubfield("b").setBibframeTag("itemPortion").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoveryObtain).setCompilanceLevels("A");
        this.getSubfield("0").setMqTag("authorityRecordControlNumber");
        this.getSubfield("2").setMqTag("source").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("A");
        this.getSubfield("6").setBibframeTag("linkage");
        this.getSubfield("8").setMqTag("fieldLink").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("O");
        this.sourceSpecificationType = SourceSpecificationType.Indicator2For055AndSubfield2;
    }
}

