/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.tags.tags01x;

import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.FRBRFunction;
import de.gwdg.metadataqa.marc.definition.Indicator;
import de.gwdg.metadataqa.marc.definition.SourceSpecificationType;
import de.gwdg.metadataqa.marc.definition.general.codelist.ClassificationSchemeSourceCodes;
import de.gwdg.metadataqa.marc.definition.general.indexer.subject.SchemaFromInd1OrIf7FromSubfield2;
import de.gwdg.metadataqa.marc.definition.general.parser.LinkageParser;

public class Tag052
extends DataFieldDefinition {
    private static Tag052 uniqueInstance;

    private Tag052() {
        this.initialize();
        this.postCreation();
    }

    public static Tag052 getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new Tag052();
        }
        return uniqueInstance;
    }

    private void initialize() {
        this.tag = "052";
        this.label = "Geographic Classification";
        this.bibframeTag = "Place";
        this.mqTag = "GeographicClassification";
        this.cardinality = Cardinality.Repeatable;
        this.descriptionUrl = "https://www.loc.gov/marc/bibliographic/bd052.html";
        this.setCompilanceLevels("O");
        this.ind1 = new Indicator("Code source").setCodes(" ", "Library of Congress Classification", "1", "U.S. Dept. of Defense Classification", "7", "Source specified in subfield $2").setHistoricalCodes("0", "U.S. Dept. of Defense Classification [OBSOLETE, 2002]").setMqTag("codeSource").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess);
        this.ind2 = new Indicator();
        this.setSubfieldsWithCardinality("a", "Geographic classification area code", "NR", "b", "Geographic classification subarea code", "R", "d", "Populated place name", "R", "2", "Code source", "NR", "6", "Linkage", "NR", "8", "Field link and sequence number", "R");
        this.getSubfield("2").setCodeList(ClassificationSchemeSourceCodes.getInstance());
        this.getSubfield("6").setContentParser(LinkageParser.getInstance());
        this.getSubfield("a").setBibframeTag("rdf:value").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoverySelect).setCompilanceLevels("M");
        this.getSubfield("b").setMqTag("subarea").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoverySelect).setCompilanceLevels("A");
        this.getSubfield("d").setBibframeTag("rdfs:label").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoverySelect).setCompilanceLevels("O");
        this.getSubfield("2").setMqTag("source").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("A");
        this.getSubfield("6").setBibframeTag("linkage").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("A");
        this.getSubfield("8").setMqTag("fieldLink").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("O");
        this.fieldIndexer = SchemaFromInd1OrIf7FromSubfield2.getInstance();
        this.sourceSpecificationType = SourceSpecificationType.Indicator1Is7AndSubfield2;
        this.setHistoricalSubfields("c", "Subject (MP) [OBSOLETE]");
    }
}

