/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.tags.tags01x;

import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.FRBRFunction;
import de.gwdg.metadataqa.marc.definition.Indicator;
import de.gwdg.metadataqa.marc.definition.general.parser.LinkageParser;

public class Tag050
extends DataFieldDefinition {
    private static Tag050 uniqueInstance;

    private Tag050() {
        this.initialize();
        this.postCreation();
    }

    public static Tag050 getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new Tag050();
        }
        return uniqueInstance;
    }

    private void initialize() {
        this.tag = "050";
        this.label = "Library of Congress Call Number";
        this.bibframeTag = "ClassificationLcc";
        this.cardinality = Cardinality.Repeatable;
        this.descriptionUrl = "https://www.loc.gov/marc/bibliographic/bd050.html";
        this.setCompilanceLevels("O");
        this.ind1 = new Indicator("Existence in LC collection").setCodes(" ", "No information provided", "0", "Item is in LC", "1", "Item is not in LC").setMqTag("existenceInLC").setFrbrFunctions(FRBRFunction.DiscoverySelect, FRBRFunction.DiscoveryObtain);
        this.ind2 = new Indicator("Source of call number").setCodes("0", "Assigned by LC", "4", "Assigned by agency other than LC").setHistoricalCodes(" ", "No information provided", "0", "No series involved", "1", "Main series", "2", "Subseries", "3", "Sub-subseries").setMqTag("source").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess);
        this.setSubfieldsWithCardinality("a", "Classification number", "R", "b", "Item number", "NR", "3", "Materials specified", "NR", "6", "Linkage", "NR", "8", "Field link and sequence number", "R");
        this.getSubfield("6").setContentParser(LinkageParser.getInstance());
        this.getSubfield("a").setBibframeTag("rdfs:label").setMqTag("rdf:value").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoveryObtain).setCompilanceLevels("M");
        this.getSubfield("b").setBibframeTag("itemPortion").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoveryObtain).setCompilanceLevels("A");
        this.getSubfield("3").setMqTag("materialsSpecified").setFrbrFunctions(FRBRFunction.DiscoveryIdentify).setCompilanceLevels("O");
        this.getSubfield("6").setBibframeTag("linkage").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("A");
        this.getSubfield("8").setMqTag("fieldLink").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("O");
        this.setHistoricalSubfields("d", "Supplementary class number (MU) [OBSOLETE, 1981]");
    }
}

