/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.tags.tags01x;

import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.FRBRFunction;
import de.gwdg.metadataqa.marc.definition.Indicator;
import de.gwdg.metadataqa.marc.definition.general.codelist.GeographicAreaCodes;
import de.gwdg.metadataqa.marc.definition.general.codelist.GeographicAreaSourceCodes;
import de.gwdg.metadataqa.marc.definition.general.parser.LinkageParser;

public class Tag043
extends DataFieldDefinition {
    private static Tag043 uniqueInstance;

    private Tag043() {
        this.initialize();
        this.postCreation();
    }

    public static Tag043 getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new Tag043();
        }
        return uniqueInstance;
    }

    private void initialize() {
        this.tag = "043";
        this.label = "Geographic Area Code";
        this.bibframeTag = "GeographicCoverage";
        this.cardinality = Cardinality.Nonrepeatable;
        this.descriptionUrl = "https://www.loc.gov/marc/bibliographic/bd043.html";
        this.setCompilanceLevels("A");
        this.ind1 = new Indicator();
        this.ind2 = new Indicator();
        this.setSubfieldsWithCardinality("a", "Geographic area code", "R", "b", "Local GAC code", "R", "c", "ISO code", "R", "0", "Authority record control number or standard number", "R", "2", "Source of local code", "R", "6", "Linkage", "NR", "8", "Field link and sequence number", "R");
        this.getSubfield("a").setCodeList(GeographicAreaCodes.getInstance());
        this.getSubfield("2").setCodeList(GeographicAreaSourceCodes.getInstance());
        this.getSubfield("6").setContentParser(LinkageParser.getInstance());
        this.getSubfield("a").setMqTag("code").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoverySelect).setCompilanceLevels("M");
        this.getSubfield("b").setMqTag("localGACcode").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoverySelect).setCompilanceLevels("O");
        this.getSubfield("c").setMqTag("ISOcode").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoverySelect);
        this.getSubfield("0").setMqTag("authorityRecordControlNumber");
        this.getSubfield("2").setMqTag("source").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("A");
        this.getSubfield("6").setBibframeTag("linkage").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("A");
        this.getSubfield("8").setMqTag("fieldLink").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("O");
    }
}

