/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.tags.tags01x;

import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.FRBRFunction;
import de.gwdg.metadataqa.marc.definition.Indicator;
import de.gwdg.metadataqa.marc.definition.general.parser.LinkageParser;

public class Tag037
extends DataFieldDefinition {
    private static Tag037 uniqueInstance;

    private Tag037() {
        this.initialize();
        this.postCreation();
    }

    public static Tag037 getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new Tag037();
        }
        return uniqueInstance;
    }

    private void initialize() {
        this.tag = "037";
        this.label = "Source of Acquisition";
        this.bibframeTag = "AcquisitionSource";
        this.cardinality = Cardinality.Repeatable;
        this.descriptionUrl = "https://www.loc.gov/marc/bibliographic/bd037.html";
        this.setCompilanceLevels("O");
        this.ind1 = new Indicator("Source of acquisition sequence").setCodes(" ", "Not applicable/No information provided/Earliest", "2", "Intervening", "3", "Current/Latest").setMqTag("source");
        this.ind2 = new Indicator();
        this.setSubfieldsWithCardinality("a", "Stock number", "NR", "b", "Source of stock number/acquisition", "NR", "c", "Terms of availability", "R", "f", "Form of issue", "R", "g", "Additional format characteristics", "R", "n", "Note", "R", "3", "Materials specified", "NR", "5", "Institution to which field applies", "R", "6", "Linkage", "NR", "8", "Field link and sequence number", "R");
        this.getSubfield("6").setContentParser(LinkageParser.getInstance());
        this.getSubfield("a").setBibframeTag("stockNumber").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoveryObtain).setCompilanceLevels("A");
        this.getSubfield("b").setBibframeTag("rdfs:label").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("M");
        this.getSubfield("c").setBibframeTag("acquisitionTerms").setFrbrFunctions(FRBRFunction.DiscoverySelect, FRBRFunction.DiscoveryObtain).setCompilanceLevels("O");
        this.getSubfield("f").setBibframeTag("note").setMqTag("formOfIssue").setFrbrFunctions(FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoverySelect, FRBRFunction.DiscoveryObtain, FRBRFunction.UseManage, FRBRFunction.UseOperate).setCompilanceLevels("O");
        this.getSubfield("g").setBibframeTag("note").setMqTag("format").setFrbrFunctions(FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoverySelect, FRBRFunction.DiscoveryObtain, FRBRFunction.UseManage, FRBRFunction.UseOperate).setCompilanceLevels("O");
        this.getSubfield("n").setBibframeTag("note").setCompilanceLevels("O");
        this.getSubfield("3").setMqTag("materialsSpecified");
        this.getSubfield("5").setMqTag("institutionToWhichFieldApplies");
        this.getSubfield("6").setBibframeTag("linkage").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("A");
        this.getSubfield("8").setMqTag("fieldLink").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("O");
    }
}

