/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.tags.tags01x;

import de.gwdg.metadataqa.marc.Code;
import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.FRBRFunction;
import de.gwdg.metadataqa.marc.definition.Indicator;
import de.gwdg.metadataqa.marc.definition.MarcVersion;
import de.gwdg.metadataqa.marc.definition.general.codelist.CartographicDataSourceCodes;
import de.gwdg.metadataqa.marc.definition.general.parser.LinkageParser;
import java.util.Arrays;

public class Tag034
extends DataFieldDefinition {
    private static Tag034 uniqueInstance;

    private Tag034() {
        this.initialize();
        this.postCreation();
    }

    public static Tag034 getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new Tag034();
        }
        return uniqueInstance;
    }

    private void initialize() {
        this.tag = "034";
        this.label = "Coded Cartographic Mathematical Data";
        this.bibframeTag = "Scale";
        this.cardinality = Cardinality.Repeatable;
        this.descriptionUrl = "https://www.loc.gov/marc/bibliographic/bd034.html";
        this.setCompilanceLevels("A", "A");
        this.ind1 = new Indicator("Type of scale").setCodes("0", "Scale indeterminable/No scale recorded", "1", "Single scale", "3", "Range of scales").putVersionSpecificCodes(MarcVersion.SZTE, Arrays.asList(new Code(" ", "Not specified"))).setHistoricalCodes("2", "Two or more scales (BK, MP, SE) [OBSOLETE]").setMqTag("typeOfScale").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess);
        this.ind2 = new Indicator("Type of ring").setCodes(" ", "Not applicable", "0", "Outer ring", "1", "Exclusion ring").setMqTag("typeOfRing").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess);
        this.setSubfieldsWithCardinality("a", "Category of scale", "NR", "b", "Constant ratio linear horizontal scale", "R", "c", "Constant ratio linear vertical scale", "R", "d", "Coordinates - westernmost longitude", "NR", "e", "Coordinates - easternmost longitude", "NR", "f", "Coordinates - northernmost latitude", "NR", "g", "Coordinates - southernmost latitude", "NR", "h", "Angular scale", "R", "j", "Declination - northern limit", "NR", "k", "Declination - southern limit", "NR", "m", "Right ascension - eastern limit", "NR", "n", "Right ascension - western limit", "NR", "p", "Equinox", "NR", "r", "Distance from earth", "NR", "s", "G-ring latitude", "R", "t", "G-ring longitude", "R", "x", "Beginning date", "NR", "y", "Ending date", "NR", "z", "Name of extraterrestrial body", "NR", "0", "Authority record control number or standard number", "R", "2", "Source", "NR", "3", "Materials specified", "NR", "6", "Linkage", "NR", "8", "Field link and sequence number", "R");
        this.getSubfield("a").setCodes("a", "Linear scale", "b", "Angular scale", "z", "Other type of scale");
        this.getSubfield("2").setCodeList(CartographicDataSourceCodes.getInstance());
        this.getSubfield("6").setContentParser(LinkageParser.getInstance());
        this.getSubfield("a").setMqTag("category").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("M", "M");
        this.getSubfield("b").setMqTag("linearHorizontalScale").setFrbrFunctions(FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoverySelect, FRBRFunction.UseInterpret).setCompilanceLevels("A", "A");
        this.getSubfield("c").setMqTag("linearVerticalScale").setFrbrFunctions(FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoverySelect, FRBRFunction.UseInterpret).setCompilanceLevels("A", "A");
        this.getSubfield("d").setMqTag("westernmostLongitude").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoverySelect, FRBRFunction.UseInterpret).setCompilanceLevels("A");
        this.getSubfield("e").setMqTag("easternmostLongitude").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoverySelect, FRBRFunction.UseInterpret).setCompilanceLevels("A");
        this.getSubfield("f").setMqTag("northernmostLatitude").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoverySelect, FRBRFunction.UseInterpret).setCompilanceLevels("A");
        this.getSubfield("g").setMqTag("southernmostLatitude").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoverySelect, FRBRFunction.UseInterpret).setCompilanceLevels("A");
        this.getSubfield("h").setMqTag("angularScale").setFrbrFunctions(FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoverySelect, FRBRFunction.UseInterpret).setCompilanceLevels("A");
        this.getSubfield("j").setMqTag("declinationNorthernLimit").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoverySelect, FRBRFunction.UseInterpret).setCompilanceLevels("A");
        this.getSubfield("k").setMqTag("declinationSouthernLimit").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoverySelect, FRBRFunction.UseInterpret).setCompilanceLevels("A");
        this.getSubfield("m").setMqTag("rightAscensionEasternLimit").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoverySelect, FRBRFunction.UseInterpret).setCompilanceLevels("A");
        this.getSubfield("n").setMqTag("rightAscensionWesternLimit").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoverySelect, FRBRFunction.UseInterpret).setCompilanceLevels("A");
        this.getSubfield("p").setMqTag("equinox").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoverySelect, FRBRFunction.UseInterpret).setCompilanceLevels("A");
        this.getSubfield("r").setMqTag("distanceFromEarth").setCompilanceLevels("A");
        this.getSubfield("s").setMqTag("gRingLatitude").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoverySelect, FRBRFunction.UseInterpret).setCompilanceLevels("A");
        this.getSubfield("t").setMqTag("gRingLongitude").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoverySelect, FRBRFunction.UseInterpret).setCompilanceLevels("A");
        this.getSubfield("x").setMqTag("beginningDate").setCompilanceLevels("A");
        this.getSubfield("y").setMqTag("endingDate").setCompilanceLevels("A");
        this.getSubfield("z").setMqTag("extraterrestrialBody").setCompilanceLevels("A");
        this.getSubfield("0").setMqTag("authorityRecordControlNumber");
        this.getSubfield("2").setMqTag("source").setCompilanceLevels("A");
        this.getSubfield("3").setMqTag("materialsSpecified");
        this.getSubfield("6").setBibframeTag("linkage").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("A", "A");
        this.getSubfield("8").setMqTag("fieldLink").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("O");
    }
}

