/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.tags.tags01x;

import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.FRBRFunction;
import de.gwdg.metadataqa.marc.definition.Indicator;
import de.gwdg.metadataqa.marc.definition.general.codelist.MusicalIncipitSchemeSourceCodes;
import de.gwdg.metadataqa.marc.definition.general.parser.LinkageParser;

public class Tag031
extends DataFieldDefinition {
    private static Tag031 uniqueInstance;

    private Tag031() {
        this.initialize();
        this.postCreation();
    }

    public static Tag031 getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new Tag031();
        }
        return uniqueInstance;
    }

    private void initialize() {
        this.tag = "031";
        this.label = "Musical Incipits Information";
        this.mqTag = "MusicalIncipits";
        this.cardinality = Cardinality.Repeatable;
        this.descriptionUrl = "https://www.loc.gov/marc/bibliographic/bd031.html";
        this.setCompilanceLevels("O");
        this.ind1 = new Indicator();
        this.ind2 = new Indicator();
        this.setSubfieldsWithCardinality("a", "Number of work", "NR", "b", "Number of movement", "NR", "c", "Number of excerpt", "NR", "d", "Caption or heading", "R", "e", "Role", "NR", "g", "Clef", "NR", "m", "Voice/instrument", "NR", "n", "Key signature", "NR", "o", "Time signature", "NR", "p", "Musical notation", "NR", "q", "General note", "R", "r", "Key or mode", "NR", "s", "Coded validity note", "R", "t", "Text incipit", "R", "u", "Uniform Resource Identifier", "R", "y", "Link text", "R", "z", "Public note", "R", "2", "System code", "NR", "6", "Linkage", "NR", "8", "Field link and sequence number", "R");
        this.getSubfield("s").setCodes("?", "there is a mistake in the incipit that has not been corrected", "+", "there is a mistake in the incipit that has been corrected", "t", "the incipit has been transcribed (e.g. from mensural notation)", "!", "incipit discrepancies have been commented on in subfield $q (General note).");
        this.getSubfield("2").setCodeList(MusicalIncipitSchemeSourceCodes.getInstance());
        this.getSubfield("6").setContentParser(LinkageParser.getInstance());
        this.getSubfield("a").setMqTag("numberOfWork").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoveryObtain).setCompilanceLevels("A");
        this.getSubfield("b").setMqTag("numberOfMovement").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoveryObtain).setCompilanceLevels("A");
        this.getSubfield("c").setMqTag("numberOfExcerpt").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoveryObtain).setCompilanceLevels("A");
        this.getSubfield("d").setMqTag("caption").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoveryObtain).setCompilanceLevels("O");
        this.getSubfield("e").setMqTag("role").setCompilanceLevels("O");
        this.getSubfield("g").setMqTag("clef").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoveryObtain).setCompilanceLevels("O");
        this.getSubfield("m").setMqTag("voiceOrInstrument").setFrbrFunctions(FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoverySelect).setCompilanceLevels("O");
        this.getSubfield("n").setMqTag("keySignature").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify).setCompilanceLevels("O");
        this.getSubfield("o").setMqTag("timeSignature").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify).setCompilanceLevels("O");
        this.getSubfield("p").setMqTag("musicalNotation").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("O");
        this.getSubfield("q").setMqTag("generalNote").setCompilanceLevels("O");
        this.getSubfield("r").setMqTag("keyOrMode").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify).setCompilanceLevels("O");
        this.getSubfield("s").setMqTag("codedValidity").setFrbrFunctions(FRBRFunction.DiscoveryObtain).setCompilanceLevels("O");
        this.getSubfield("t").setMqTag("incipit").setCompilanceLevels("A");
        this.getSubfield("u").setMqTag("uri").setFrbrFunctions(FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoveryObtain).setCompilanceLevels("O");
        this.getSubfield("y").setMqTag("linkText").setCompilanceLevels("O");
        this.getSubfield("z").setMqTag("publicNote").setFrbrFunctions(FRBRFunction.DiscoveryObtain).setCompilanceLevels("O");
        this.getSubfield("2").setBibframeTag("systemCode").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("O");
        this.getSubfield("6").setBibframeTag("linkage").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("A");
        this.getSubfield("8").setMqTag("fieldLink").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("O");
    }
}

