/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.tags.tags01x;

import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.FRBRFunction;
import de.gwdg.metadataqa.marc.definition.Indicator;
import de.gwdg.metadataqa.marc.definition.general.codelist.FingerprintSchemeSourceCodes;
import de.gwdg.metadataqa.marc.definition.general.codelist.OrganizationCodes;
import de.gwdg.metadataqa.marc.definition.general.parser.LinkageParser;

public class Tag026
extends DataFieldDefinition {
    private static Tag026 uniqueInstance;

    private Tag026() {
        this.initialize();
        this.postCreation();
    }

    public static Tag026 getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new Tag026();
        }
        return uniqueInstance;
    }

    private void initialize() {
        this.tag = "026";
        this.label = "Fingerprint Identifier";
        this.bibframeTag = "Fingerprint";
        this.cardinality = Cardinality.Repeatable;
        this.descriptionUrl = "https://www.loc.gov/marc/bibliographic/bd026.html";
        this.setCompilanceLevels("O");
        this.ind1 = new Indicator();
        this.ind2 = new Indicator();
        this.setSubfieldsWithCardinality("a", "First and second groups of characters", "NR", "b", "Third and fourth groups of characters", "NR", "c", "Date", "NR", "d", "Number of volume or part", "R", "e", "Unparsed fingerprint", "NR", "2", "Source", "NR", "5", "Institution to which field applies", "R", "6", "Linkage", "NR", "8", "Field link and sequence number", "R");
        this.getSubfield("2").setCodeList(FingerprintSchemeSourceCodes.getInstance());
        this.getSubfield("5").setCodeList(OrganizationCodes.getInstance());
        this.getSubfield("6").setContentParser(LinkageParser.getInstance());
        this.getSubfield("a").setBibframeTag("rdf:value").setMqTag("firstAndSecondGroups").setFrbrFunctions(FRBRFunction.DiscoveryIdentify).setCompilanceLevels("A");
        this.getSubfield("b").setBibframeTag("rdf:value").setMqTag("thirdAndFourthGroups").setFrbrFunctions(FRBRFunction.DiscoveryIdentify).setCompilanceLevels("A");
        this.getSubfield("c").setBibframeTag("rdf:value").setMqTag("date").setCompilanceLevels("A");
        this.getSubfield("d").setBibframeTag("rdf:value").setMqTag("volume").setFrbrFunctions(FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoverySelect).setCompilanceLevels("A");
        this.getSubfield("e").setBibframeTag("rdf:value").setMqTag("unparsed").setFrbrFunctions(FRBRFunction.DiscoveryIdentify).setCompilanceLevels("A");
        this.getSubfield("2").setBibframeTag("source").setCompilanceLevels("A");
        this.getSubfield("5").setMqTag("institutionToWhichFieldApplies").setFrbrFunctions(FRBRFunction.ManagementProcess, FRBRFunction.ManagementDisplay).setCompilanceLevels("A");
        this.getSubfield("6").setBibframeTag("linkage").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("A");
        this.getSubfield("8").setMqTag("fieldLink").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("O");
    }
}

