/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.tags.tags01x;

import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.FRBRFunction;
import de.gwdg.metadataqa.marc.definition.Indicator;
import de.gwdg.metadataqa.marc.definition.MarcVersion;
import de.gwdg.metadataqa.marc.definition.SubfieldDefinition;
import de.gwdg.metadataqa.marc.definition.general.parser.LinkageParser;
import de.gwdg.metadataqa.marc.definition.general.validator.ISBNValidator;
import java.util.Arrays;

public class Tag020
extends DataFieldDefinition {
    private static Tag020 uniqueInstance;

    private Tag020() {
        this.initialize();
        this.postCreation();
    }

    public static Tag020 getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new Tag020();
        }
        return uniqueInstance;
    }

    private void initialize() {
        this.tag = "020";
        this.label = "International Standard Book Number";
        this.bibframeTag = "Isbn";
        this.cardinality = Cardinality.Repeatable;
        this.descriptionUrl = "https://www.loc.gov/marc/bibliographic/bd020.html";
        this.setCompilanceLevels("A", "A");
        this.ind1 = new Indicator();
        this.ind2 = new Indicator();
        this.setSubfieldsWithCardinality("a", "International Standard Book Number", "NR", "c", "Terms of availability", "NR", "q", "Qualifying information", "R", "z", "Canceled/invalid ISBN", "R", "6", "Linkage", "NR", "8", "Field link and sequence number", "R");
        this.getSubfield("a").setValidator(ISBNValidator.getInstance());
        this.getSubfield("6").setContentParser(LinkageParser.getInstance());
        this.getSubfield("a").setBibframeTag("rdf:value").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoveryObtain).setCompilanceLevels("A", "A");
        this.getSubfield("c").setBibframeTag("acquisitionTerms").setFrbrFunctions(FRBRFunction.DiscoverySelect, FRBRFunction.DiscoveryObtain).setCompilanceLevels("A", "A");
        this.getSubfield("q").setBibframeTag("qualifier");
        this.getSubfield("z").setMqTag("canceledOrInvalidISBN").setFrbrFunctions(FRBRFunction.DiscoverySearch, FRBRFunction.DiscoveryIdentify, FRBRFunction.DiscoveryObtain).setCompilanceLevels("A", "A");
        this.getSubfield("6").setMqTag("linkage").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("A", "A");
        this.getSubfield("8").setMqTag("fieldLink").setFrbrFunctions(FRBRFunction.ManagementIdentify, FRBRFunction.ManagementProcess).setCompilanceLevels("O");
        this.setHistoricalSubfields("b", "Binding information (BK, MP, MU) [OBSOLETE]");
        this.putVersionSpecificSubfields(MarcVersion.DNB, Arrays.asList(new SubfieldDefinition("9", "ISBN mit Bindestrichen", "R")));
    }
}

