/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.tags.oclctags;

import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.Indicator;
import de.gwdg.metadataqa.marc.definition.general.codelist.oclc.FormOfItem;
import de.gwdg.metadataqa.marc.definition.general.codelist.oclc.Frequency;
import de.gwdg.metadataqa.marc.definition.general.codelist.oclc.Regularity;
import de.gwdg.metadataqa.marc.definition.general.codelist.oclc.TypeOfDateOrPublicationStatus;

public class Tag539
extends DataFieldDefinition {
    private static Tag539 uniqueInstance;

    private Tag539() {
        this.initialize();
        this.postCreation();
    }

    public static Tag539 getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new Tag539();
        }
        return uniqueInstance;
    }

    private void initialize() {
        this.tag = "539";
        this.label = "Fixed-Length Data Elements of Reproduction Note";
        this.mqTag = "Reproduction";
        this.cardinality = Cardinality.Repeatable;
        this.descriptionUrl = "http://www.oclc.org/bibformats/en/5xx/539.html";
        this.ind1 = new Indicator("The type of system control number").setCodes("0", "Primary control number", "1", "Secondary control number").setMqTag("controlNumberType");
        this.ind2 = new Indicator();
        this.setSubfieldsWithCardinality("a", "Type of date/Publication status", "NR", "b", "Date 1/Beginning date of publication", "NR", "c", "Date 2/Ending date of publication", "NR", "d", "Place of publication, production, or execution", "NR", "e", "Frequency", "NR", "f", "Regularity", "NR", "g", "Form of item", "NR");
        this.getSubfield("a").setCodeList(TypeOfDateOrPublicationStatus.getInstance());
        this.getSubfield("e").setCodeList(Frequency.getInstance());
        this.getSubfield("f").setCodeList(Regularity.getInstance());
        this.getSubfield("g").setCodeList(FormOfItem.getInstance());
        this.getSubfield("a").setMqTag("type");
        this.getSubfield("b").setMqTag("date1");
        this.getSubfield("c").setMqTag("date2");
        this.getSubfield("d").setMqTag("place");
        this.getSubfield("e").setMqTag("frequency");
        this.getSubfield("f").setMqTag("regularity");
        this.getSubfield("g").setMqTag("form");
    }
}

