/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.general.indexer.subject;

import java.util.HashMap;
import java.util.Map;

public class ClassificationSchemes {
    Map<String, String> schemes = new HashMap<String, String>();
    private static ClassificationSchemes uniqueInstance;

    private void initialize() {
        this.schemes.put("Library of Congress Subject Headings", "lcsh0");
        this.schemes.put("LC subject headings for children's literature", "lcchild");
        this.schemes.put("Medical Subject Headings", "mesh");
        this.schemes.put("National Agricultural Library subject authority file", "nal");
        this.schemes.put("Source not specified", "unspec");
        this.schemes.put("Canadian Subject Headings", "cansh");
        this.schemes.put("R\u00e9pertoire de vedettes-mati\u00e8re", "rvm");
        this.schemes.put("NAL subject category code list", "nal");
        this.schemes.put("Superintendent of Documents Classification System", "sudocs");
        this.schemes.put("Government of Canada Publications: Outline of Classification", "gcp");
        this.schemes.put("Library of Congress Classification", "lcc");
        this.schemes.put("U.S. Dept. of Defense Classification", "usdodc");
        this.schemes.put("No information provided", "unspec");
        this.schemes.put("Dewey Decimal classification", "ddc");
        this.schemes.put("National Library of Medicine classification", "nlm");
        this.schemes.put("Superintendent of Documents classification", "sudocs");
        this.schemes.put("Shelving control number", "shelfcn");
        this.schemes.put("Title", "title");
        this.schemes.put("Shelved separately", "shelfs");
        this.schemes.put("Other scheme", "other");
        this.schemes.put("Universal Decimal Classification", "udc");
        this.schemes.put("Dewey Decimal Classification", "ddc");
    }

    public String resolve(String key) {
        if (this.schemes.containsKey(key)) {
            return this.schemes.get(key);
        }
        throw new IllegalArgumentException(String.format("Key '%s' is not recognized as a classification scheme", key));
    }

    private ClassificationSchemes() {
        this.initialize();
    }

    public static ClassificationSchemes getInstance() {
        if (uniqueInstance == null) {
            uniqueInstance = new ClassificationSchemes();
        }
        return uniqueInstance;
    }
}

