/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition.general;

import de.gwdg.metadataqa.marc.Extractable;
import de.gwdg.metadataqa.marc.model.SolrFieldType;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Linkage
implements Extractable,
Serializable {
    private String linkingTag;
    private String occurrenceNumber;
    private String scriptIdentificationCode;
    private String fieldOrientationCode;
    private static Map<String, String> scriptIdentificationCodes = new HashMap<String, String>();
    private static Map<String, String> fieldOrientationCodes;

    public Linkage(String linkingTag, String occurrenceNumber) {
        this.linkingTag = linkingTag;
        this.occurrenceNumber = occurrenceNumber;
    }

    public void setScriptIdentificationCode(String scriptIdentificationCode) {
        this.scriptIdentificationCode = scriptIdentificationCode;
    }

    public void setFieldOrientationCode(String fieldOrientationCode) {
        this.fieldOrientationCode = fieldOrientationCode;
    }

    @Override
    public Map<String, List<String>> getKeyValuePairs() {
        return this.getKeyValuePairs(SolrFieldType.MARC);
    }

    @Override
    public Map<String, List<String>> getKeyValuePairs(SolrFieldType type) {
        LinkedHashMap<String, List<String>> map = new LinkedHashMap<String, List<String>>();
        Map<String, String> simpleMap = this.getMap();
        for (Map.Entry<String, String> entry : simpleMap.entrySet()) {
            map.put(entry.getKey(), Arrays.asList(entry.getValue()));
        }
        return map;
    }

    public Map<String, String> getMap() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("linkingTag", this.linkingTag);
        map.put("occurrenceNumber", this.occurrenceNumber);
        if (this.scriptIdentificationCode != null) {
            map.put("scriptIdentificationCode", this.resolveScriptIdentificationCode());
        }
        if (this.fieldOrientationCode != null) {
            map.put("fieldOrientationCode", this.resolveFieldOrientationCode());
        }
        return map;
    }

    public String resolveScriptIdentificationCode() {
        if (scriptIdentificationCodes.containsKey(this.scriptIdentificationCode)) {
            return scriptIdentificationCodes.get(this.scriptIdentificationCode);
        }
        return this.scriptIdentificationCode;
    }

    public String resolveFieldOrientationCode() {
        if (fieldOrientationCodes.containsKey(this.fieldOrientationCode)) {
            return fieldOrientationCodes.get(this.fieldOrientationCode);
        }
        return this.fieldOrientationCode;
    }

    public String getLinkingTag() {
        return this.linkingTag;
    }

    public String getOccurrenceNumber() {
        return this.occurrenceNumber;
    }

    public String getScriptIdentificationCode() {
        return this.scriptIdentificationCode;
    }

    public String getFieldOrientationCode() {
        return this.fieldOrientationCode;
    }

    public String toString() {
        return "Linkage{linkingTag='" + this.linkingTag + '\'' + ", occurrenceNumber='" + this.occurrenceNumber + '\'' + ", scriptIdentificationCode='" + this.resolveScriptIdentificationCode() + '\'' + ", fieldOrientationCode='" + this.fieldOrientationCode + '\'' + '}';
    }

    static {
        scriptIdentificationCodes.put("(3", "Arabic");
        scriptIdentificationCodes.put("(B", "Latin");
        scriptIdentificationCodes.put("$1", "Chinese, Japanese, Korean");
        scriptIdentificationCodes.put("(N", "Cyrillic");
        scriptIdentificationCodes.put("(S", "Greek");
        scriptIdentificationCodes.put("(2", "Hebrew");
        fieldOrientationCodes = new HashMap<String, String>();
        fieldOrientationCodes.put("r", "right-to-left");
    }
}

