/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition;

import de.gwdg.metadataqa.marc.Code;
import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.CompilanceLevel;
import de.gwdg.metadataqa.marc.definition.ControlSubfieldDefinition;
import de.gwdg.metadataqa.marc.definition.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.FRBRFunction;
import de.gwdg.metadataqa.marc.definition.general.codelist.CodeList;
import de.gwdg.metadataqa.marc.definition.general.parser.SubfieldContentParser;
import de.gwdg.metadataqa.marc.definition.general.validator.SubfieldValidator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.commons.lang3.StringUtils;

public class SubfieldDefinition
implements Serializable {
    private static final Logger logger = Logger.getLogger(SubfieldDefinition.class.getCanonicalName());
    private String code;
    private String bibframeTag;
    private String mqTag;
    private String cardinalityCode;
    private String label;
    private DataFieldDefinition parent;
    private SubfieldValidator validator;
    private SubfieldContentParser contentParser;
    protected CodeList codeList;
    private List<Code> codes;
    private List<String> allowedCodes;
    private String codeForIndex = null;
    private List<ControlSubfieldDefinition> positions;
    private List<FRBRFunction> functions;
    private CompilanceLevel nationalCompilanceLevel;
    private CompilanceLevel minimalCompilanceLevel;

    public String getCodeForIndex() {
        if (this.codeForIndex == null) {
            if (this.mqTag != null) {
                this.codeForIndex = this.mqTag.equals("rdf:value") ? "" : "_" + this.mqTag;
            } else if (this.bibframeTag != null) {
                switch (this.bibframeTag) {
                    case "rdf:value": {
                        this.codeForIndex = "";
                        break;
                    }
                    case "rdfs:label": {
                        this.codeForIndex = "label";
                        break;
                    }
                    default: {
                        this.codeForIndex = "_" + this.bibframeTag;
                        break;
                    }
                }
            } else {
                this.codeForIndex = "_" + this.code;
            }
        }
        return this.codeForIndex;
    }

    public SubfieldDefinition(String code, String label) {
        this.code = code;
        this.label = label;
    }

    public SubfieldDefinition(String code, String label, String cardinalityCode) {
        this.code = code;
        this.label = label;
        this.cardinalityCode = cardinalityCode;
        if (code.startsWith("ind")) {
            this.processIndicatorType(cardinalityCode);
        }
    }

    public String getCode() {
        return this.code;
    }

    public String getPath() {
        return String.format("%s$%s", this.getParent().getTag(), this.getCode());
    }

    public SubfieldDefinition setCodes(List<Code> codes) {
        this.codes = codes;
        return this;
    }

    public SubfieldDefinition setCodes(String ... input) {
        this.codes = new ArrayList<Code>();
        for (int i = 0; i < input.length; i += 2) {
            this.codes.add(new Code(input[i], input[i + 1]));
        }
        return this;
    }

    public Code getCode(String _code) {
        for (Code code : this.codes) {
            if (code.getCode().equals(_code)) {
                return code;
            }
            if (!code.isRange() || !code.getRange().isValid(_code)) continue;
            return code;
        }
        return null;
    }

    public List<Code> getCodes() {
        return this.codes;
    }

    public String getCardinalityCode() {
        return this.cardinalityCode;
    }

    public Cardinality getCardinality() {
        return Cardinality.byCode(this.cardinalityCode);
    }

    public String getLabel() {
        return this.label;
    }

    public List<String> getAllowedCodes() {
        return this.allowedCodes;
    }

    public SubfieldContentParser getContentParser() {
        return this.contentParser;
    }

    public boolean hasContentParser() {
        return this.contentParser != null;
    }

    public SubfieldDefinition setContentParser(SubfieldContentParser contentParser) {
        this.contentParser = contentParser;
        return this;
    }

    private void processIndicatorType(String types) {
        this.allowedCodes = new ArrayList<String>();
        if (types.equals("blank")) {
            this.allowedCodes.add(" ");
        } else {
            int len = types.length();
            for (int i = 0; i < len; ++i) {
                String type = String.valueOf(types.charAt(i));
                if (type.equals("b")) {
                    type = " ";
                }
                this.allowedCodes.add(type);
            }
        }
    }

    public SubfieldDefinition setValidator(SubfieldValidator validator) {
        this.validator = validator;
        return this;
    }

    public boolean hasValidator() {
        return this.validator != null;
    }

    public SubfieldValidator getValidator() {
        return this.validator;
    }

    public SubfieldDefinition setCodeList(CodeList codeList) {
        this.codeList = codeList;
        return this;
    }

    public CodeList getCodeList() {
        return this.codeList;
    }

    public String resolve(String value) {
        Code code;
        if (this.codeList != null && this.codeList.isValid(value)) {
            return this.codeList.getCode(value).getLabel();
        }
        if (this.codes != null && (code = this.getCode(value)) != null) {
            return code.getLabel();
        }
        return value;
    }

    public Map<String, String> resolvePositional(String value) {
        LinkedHashMap<String, String> pairs = new LinkedHashMap<String, String>();
        int i = 0;
        for (ControlSubfieldDefinition def : this.getPositions()) {
            String part = value.substring(def.getPositionStart(), def.getPositionEnd());
            String resolved = def.resolve(part);
            String suffix = StringUtils.isNotBlank((CharSequence)def.getMqTag()) ? def.getMqTag() : String.valueOf(i);
            pairs.put(suffix, resolved);
            ++i;
        }
        return pairs;
    }

    public String getBibframeTag() {
        return this.bibframeTag;
    }

    public SubfieldDefinition setBibframeTag(String bibframeTag) {
        this.bibframeTag = bibframeTag;
        return this;
    }

    public String getMqTag() {
        return this.mqTag;
    }

    public DataFieldDefinition getParent() {
        return this.parent;
    }

    public List<FRBRFunction> getFrbrFunctions() {
        return this.functions;
    }

    public SubfieldDefinition setParent(DataFieldDefinition parent) {
        this.parent = parent;
        return this;
    }

    public SubfieldDefinition setMqTag(String mqTag) {
        this.mqTag = mqTag;
        return this;
    }

    public void setPositions(List<ControlSubfieldDefinition> positions) {
        this.positions = positions;
    }

    public List<ControlSubfieldDefinition> getPositions() {
        return this.positions;
    }

    public boolean hasPositions() {
        return this.positions != null;
    }

    public SubfieldDefinition setCompilanceLevels(String national) {
        this.setNationalCompilanceLevel(national);
        return this;
    }

    public SubfieldDefinition setCompilanceLevels(String national, String minimal) {
        this.setNationalCompilanceLevel(national);
        this.setMinimalCompilanceLevel(minimal);
        return this;
    }

    public CompilanceLevel getNationalCompilanceLevel() {
        return this.nationalCompilanceLevel;
    }

    public SubfieldDefinition setNationalCompilanceLevel(CompilanceLevel nationalLevel) {
        this.nationalCompilanceLevel = nationalLevel;
        return this;
    }

    public SubfieldDefinition setNationalCompilanceLevel(String level) {
        if (StringUtils.isNotBlank((CharSequence)level)) {
            this.nationalCompilanceLevel = CompilanceLevel.byAbbreviation(level);
        }
        return this;
    }

    public CompilanceLevel getMinimalCompilanceLevel() {
        return this.minimalCompilanceLevel;
    }

    public SubfieldDefinition setMinimalCompilanceLevel(String level) {
        if (StringUtils.isNotBlank((CharSequence)level)) {
            this.minimalCompilanceLevel = CompilanceLevel.byAbbreviation(level);
        }
        return this;
    }

    public SubfieldDefinition setMinimalCompilanceLevel(CompilanceLevel minimalLevel) {
        this.minimalCompilanceLevel = minimalLevel;
        return this;
    }

    public String toString() {
        return "MarcSubfield{code='" + this.code + '\'' + ", typeCode='" + this.cardinalityCode + '\'' + ", label='" + this.label + '\'' + '}';
    }

    public SubfieldDefinition setFrbrFunctions(FRBRFunction ... functions) {
        this.functions = Arrays.asList(functions);
        return this;
    }
}

