/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition;

import de.gwdg.metadataqa.marc.Extractable;
import de.gwdg.metadataqa.marc.MarcRecord;
import de.gwdg.metadataqa.marc.Validatable;
import de.gwdg.metadataqa.marc.definition.ControlField;
import de.gwdg.metadataqa.marc.definition.ControlSubfieldDefinition;
import de.gwdg.metadataqa.marc.definition.ControlValue;
import de.gwdg.metadataqa.marc.definition.MarcVersion;
import de.gwdg.metadataqa.marc.model.SolrFieldType;
import de.gwdg.metadataqa.marc.model.validation.ValidationError;
import de.gwdg.metadataqa.marc.utils.keygenerator.PositionalControlFieldKeyGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class PositionalControlField
extends ControlField
implements Extractable,
Validatable {
    protected MarcRecord marcRecord;
    protected Map<ControlSubfieldDefinition, String> valuesMap;
    protected List<ControlValue> valuesList;
    protected List<ValidationError> validationErrors;

    @Override
    public boolean validate(MarcVersion marcVersion) {
        boolean isValid = true;
        this.validationErrors = new ArrayList<ValidationError>();
        for (ControlValue controlValue : this.valuesList) {
            if (controlValue.validate(marcVersion)) continue;
            this.validationErrors.addAll(controlValue.getValidationErrors());
            isValid = false;
        }
        return isValid;
    }

    public void setMarcRecord(MarcRecord marcRecord) {
        this.marcRecord = marcRecord;
        for (ControlValue value : this.valuesList) {
            value.setRecord(marcRecord);
        }
    }

    @Override
    public List<ValidationError> getValidationErrors() {
        return this.validationErrors;
    }

    @Override
    public Map<String, List<String>> getKeyValuePairs() {
        return this.getKeyValuePairs(SolrFieldType.MARC);
    }

    public Map<String, List<String>> getKeyValuePairs(String tag, String mqTag, SolrFieldType type) {
        LinkedHashMap<String, List<String>> map = new LinkedHashMap<String, List<String>>();
        PositionalControlFieldKeyGenerator keyGenerator = new PositionalControlFieldKeyGenerator(tag, mqTag, type);
        if (this.content != null) {
            map.put(keyGenerator.forTag(), Arrays.asList(this.content));
            for (Map.Entry<ControlSubfieldDefinition, String> entry : this.valuesMap.entrySet()) {
                ControlSubfieldDefinition controlSubfield = entry.getKey();
                String value = controlSubfield.resolve(entry.getValue());
                map.put(keyGenerator.forSubfield(controlSubfield), Arrays.asList(value));
            }
        }
        return map;
    }

    public Map<ControlSubfieldDefinition, String> getMap() {
        return this.valuesMap;
    }
}

