/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition;

import de.gwdg.metadataqa.marc.Code;
import de.gwdg.metadataqa.marc.Range;
import de.gwdg.metadataqa.marc.definition.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.FRBRFunction;
import de.gwdg.metadataqa.marc.definition.MarcVersion;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Indicator {
    private DataFieldDefinition parent;
    private String label = null;
    private String bibframeTag = null;
    private String mqTag = null;
    private String indexTag = null;
    private List<Code> codes;
    protected List<Code> historicalCodes;
    private Map<String, Code> codeIndex = new LinkedHashMap<String, Code>();
    private Map<String, Code> historicalCodeIndex = new LinkedHashMap<String, Code>();
    private Map<Range, Code> ranges;
    private String indicatorFlag;
    private Map<MarcVersion, List<Code>> versionSpecificCodes;
    private List<FRBRFunction> functions;

    public Indicator() {
    }

    public Indicator(String label) {
        this.label = label;
    }

    public Indicator(String label, List<Code> codes) {
        this.label = label;
        this.codes = codes;
        this.indexCodes();
    }

    public String getPath() {
        return String.format("%s$%s", this.parent.getTag(), this.indicatorFlag);
    }

    public String getIndexTag() {
        if (this.indexTag == null) {
            this.indexTag = this.mqTag != null ? this.mqTag : (this.bibframeTag != null ? this.bibframeTag.replace("/", "") : this.indicatorFlag);
        }
        return this.indexTag;
    }

    public Indicator setLabel(String label) {
        this.label = label;
        return this;
    }

    public Indicator setCodes(List<Code> codes) {
        this.codes = codes;
        return this;
    }

    public Indicator setCodes(String ... input) {
        this.codes = new ArrayList<Code>();
        for (int i = 0; i < input.length; i += 2) {
            this.codes.add(new Code(input[i], input[i + 1]));
        }
        this.indexCodes();
        return this;
    }

    public Indicator setHistoricalCodes(String ... input) {
        this.historicalCodes = new ArrayList<Code>();
        for (int i = 0; i < input.length; i += 2) {
            this.historicalCodes.add(new Code(input[i], input[i + 1]));
        }
        this.indexHistoricalCodes();
        return this;
    }

    public String getLabel() {
        return this.label;
    }

    public String getBibframeTag() {
        return this.bibframeTag;
    }

    public void setBibframeTag(String bibframeTag) {
        this.bibframeTag = bibframeTag;
    }

    public String getMqTag() {
        return this.mqTag;
    }

    public Indicator setMqTag(String mqTag) {
        this.mqTag = mqTag;
        return this;
    }

    public boolean exists() {
        return this.label != null && !this.label.equals("");
    }

    public List<Code> getCodes() {
        return this.codes;
    }

    public Code getCode(String codeString) {
        if (this.codeIndex.containsKey(codeString)) {
            return this.codeIndex.get(codeString);
        }
        for (Range range : this.getRanges().keySet()) {
            if (!range.isValid(codeString)) continue;
            return this.ranges.get(range);
        }
        return null;
    }

    public boolean hasCode(String code) {
        if (this.codeIndex.containsKey(code)) {
            return true;
        }
        for (Range range : this.getRanges().keySet()) {
            if (!range.isValid(code)) continue;
            return true;
        }
        return false;
    }

    private Map<Range, Code> getRanges() {
        if (this.ranges == null) {
            this.ranges = new HashMap<Range, Code>();
            for (Code code : this.codes) {
                if (!code.isRange()) continue;
                this.ranges.put(code.getRange(), code);
            }
        }
        return this.ranges;
    }

    private void indexCodes() {
        this.codeIndex = new LinkedHashMap<String, Code>();
        for (Code code : this.codes) {
            this.codeIndex.put(code.getCode(), code);
        }
    }

    private void indexHistoricalCodes() {
        this.historicalCodeIndex = new LinkedHashMap<String, Code>();
        for (Code code : this.historicalCodes) {
            this.historicalCodeIndex.put(code.getCode(), code);
        }
    }

    public boolean isHistoricalCode(String code) {
        return this.historicalCodes != null && !this.historicalCodes.isEmpty() && this.historicalCodeIndex.containsKey(code);
    }

    public void setIndicatorFlag(String indicatorFlag) {
        this.indicatorFlag = indicatorFlag;
    }

    public void setParent(DataFieldDefinition parent) {
        this.parent = parent;
    }

    public Indicator putVersionSpecificCodes(MarcVersion marcVersion, List<Code> codeList) {
        if (this.versionSpecificCodes == null) {
            this.versionSpecificCodes = new HashMap<MarcVersion, List<Code>>();
        }
        this.versionSpecificCodes.put(marcVersion, codeList);
        return this;
    }

    public boolean hasVersionSpecificCodes(MarcVersion marcVersion) {
        return this.versionSpecificCodes.containsKey((Object)marcVersion);
    }

    public List<Code> getHistoricalCodes() {
        return this.historicalCodes;
    }

    public boolean isVersionSpecificCode(MarcVersion marcVersion, String code) {
        return this.versionSpecificCodes != null && !this.versionSpecificCodes.isEmpty() && this.versionSpecificCodes.containsKey((Object)marcVersion) && !this.versionSpecificCodes.get((Object)marcVersion).isEmpty() && !this.versionSpecificCodes.get((Object)marcVersion).contains(code);
    }

    public String toString() {
        return "Indicator{label='" + this.label + '\'' + ", codes=" + this.codes + ", indicatorFlag='" + this.indicatorFlag + '\'' + '}';
    }

    public Indicator setFrbrFunctions(FRBRFunction ... functions) {
        this.functions = Arrays.asList(functions);
        return this;
    }

    public List<FRBRFunction> getFrbrFunctions() {
        return this.functions;
    }

    public String getIndicatorFlag() {
        return this.indicatorFlag;
    }
}

