/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition;

import de.gwdg.metadataqa.marc.Code;
import de.gwdg.metadataqa.marc.definition.Cardinality;
import de.gwdg.metadataqa.marc.definition.CompilanceLevel;
import de.gwdg.metadataqa.marc.definition.FRBRFunction;
import de.gwdg.metadataqa.marc.definition.Indicator;
import de.gwdg.metadataqa.marc.definition.MarcVersion;
import de.gwdg.metadataqa.marc.definition.SourceSpecificationType;
import de.gwdg.metadataqa.marc.definition.SubfieldDefinition;
import de.gwdg.metadataqa.marc.definition.general.indexer.FieldIndexer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public abstract class DataFieldDefinition
implements Serializable {
    protected String tag;
    protected String bibframeTag;
    protected String mqTag;
    protected String label;
    protected Cardinality cardinality = Cardinality.Nonrepeatable;
    protected Indicator ind1;
    protected Indicator ind2;
    protected String descriptionUrl;
    protected List<SubfieldDefinition> subfields;
    protected Map<String, SubfieldDefinition> subfieldIndex = new LinkedHashMap<String, SubfieldDefinition>();
    protected List<Code> historicalSubfields;
    protected Map<String, Code> historicalSubfieldsIndex;
    protected String indexTag = null;
    protected Map<MarcVersion, List<SubfieldDefinition>> versionSpecificSubfields;
    protected List<FRBRFunction> functions;
    protected FieldIndexer fieldIndexer = null;
    protected SourceSpecificationType sourceSpecificationType = null;
    private CompilanceLevel nationalCompilanceLevel;
    private CompilanceLevel minimalCompilanceLevel;

    public String getTag() {
        return this.tag;
    }

    public String getIndexTag() {
        if (this.indexTag == null) {
            this.indexTag = this.mqTag != null ? this.mqTag : (this.bibframeTag != null ? this.bibframeTag.replace("/", "") : this.tag);
        }
        return this.indexTag;
    }

    public String getLabel() {
        return this.label;
    }

    public Cardinality getCardinality() {
        return this.cardinality;
    }

    public Indicator getInd1() {
        return this.ind1;
    }

    public Indicator getInd2() {
        return this.ind2;
    }

    public List<Indicator> getIndicators() {
        return Arrays.asList(this.ind1, this.ind2);
    }

    protected void postCreation() {
        this.setIndicatorFlags();
    }

    protected void setIndicatorFlags() {
        if (this.ind1 != null) {
            this.ind1.setParent(this);
            this.ind1.setIndicatorFlag("ind1");
        }
        if (this.ind2 != null) {
            this.ind2.setParent(this);
            this.ind2.setIndicatorFlag("ind2");
        }
    }

    public List<SubfieldDefinition> getSubfields() {
        return this.subfields;
    }

    protected void setSubfields(String ... input) {
        this.subfields = new ArrayList<SubfieldDefinition>();
        for (int i = 0; i < input.length; i += 2) {
            this.subfields.add(new SubfieldDefinition(input[i], input[i + 1]));
        }
        this.indexSubfields();
    }

    protected void setSubfieldsWithCardinality(String ... input) {
        this.subfields = new ArrayList<SubfieldDefinition>();
        for (int i = 0; i < input.length; i += 3) {
            String code = input[i];
            String label = input[i + 1];
            String cardinality = input[i + 2];
            SubfieldDefinition definition = new SubfieldDefinition(code, label, cardinality);
            definition.setParent(this);
            this.subfields.add(definition);
        }
        this.indexSubfields();
    }

    protected void indexSubfields() {
        for (SubfieldDefinition subfield : this.subfields) {
            this.subfieldIndex.put(subfield.getCode(), subfield);
        }
    }

    protected DataFieldDefinition setHistoricalSubfields(String ... input) {
        this.historicalSubfields = new ArrayList<Code>();
        for (int i = 0; i < input.length; i += 2) {
            this.historicalSubfields.add(new Code(input[i], input[i + 1]));
        }
        this.indexHistoricalSubfields();
        return this;
    }

    private void indexHistoricalSubfields() {
        this.historicalSubfieldsIndex = new LinkedHashMap<String, Code>();
        for (Code code : this.historicalSubfields) {
            this.historicalSubfieldsIndex.put(code.getCode(), code);
        }
    }

    public boolean isHistoricalSubfield(String code) {
        return this.historicalSubfields != null && !this.historicalSubfields.isEmpty() && this.historicalSubfieldsIndex.containsKey(code);
    }

    public String getDescriptionUrl() {
        return this.descriptionUrl;
    }

    public SubfieldDefinition getSubfield(String code) {
        return this.subfieldIndex.getOrDefault(code, null);
    }

    public void putVersionSpecificSubfields(MarcVersion marcVersion, List<SubfieldDefinition> subfieldDefinitions) {
        if (this.versionSpecificSubfields == null) {
            this.versionSpecificSubfields = new HashMap<MarcVersion, List<SubfieldDefinition>>();
        }
        for (SubfieldDefinition subfieldDefinition : subfieldDefinitions) {
            subfieldDefinition.setParent(this);
        }
        this.versionSpecificSubfields.put(marcVersion, subfieldDefinitions);
    }

    public boolean hasVersionSpecificSubfields(MarcVersion marcVersion) {
        return this.versionSpecificSubfields.containsKey((Object)marcVersion);
    }

    public boolean isVersionSpecificSubfields(MarcVersion marcVersion, String code) {
        if (this.versionSpecificSubfields != null && !this.versionSpecificSubfields.isEmpty() && this.versionSpecificSubfields.containsKey((Object)marcVersion) && !this.versionSpecificSubfields.get((Object)marcVersion).isEmpty()) {
            for (SubfieldDefinition subfieldDefinition : this.versionSpecificSubfields.get((Object)marcVersion)) {
                if (!subfieldDefinition.getCode().equals(code)) continue;
                return true;
            }
        }
        return false;
    }

    public SubfieldDefinition getVersionSpecificSubfield(MarcVersion marcVersion, String code) {
        if (this.isVersionSpecificSubfields(marcVersion, code)) {
            for (SubfieldDefinition subfieldDefinition : this.versionSpecificSubfields.get((Object)marcVersion)) {
                if (!subfieldDefinition.getCode().equals(code)) continue;
                return subfieldDefinition;
            }
        }
        return null;
    }

    public List<Code> getHistoricalSubfields() {
        return this.historicalSubfields;
    }

    public String getMqTag() {
        return this.mqTag;
    }

    public List<FRBRFunction> getFrbrFunctions() {
        return this.functions;
    }

    public FieldIndexer getFieldIndexer() {
        return this.fieldIndexer;
    }

    public SourceSpecificationType getSourceSpecificationType() {
        return this.sourceSpecificationType;
    }

    public void setCompilanceLevels(String national) {
        this.setNationalCompilanceLevel(national);
    }

    public void setCompilanceLevels(String national, String minimal) {
        this.setNationalCompilanceLevel(national);
        this.setMinimalCompilanceLevel(minimal);
    }

    public CompilanceLevel getNationalCompilanceLevel() {
        return this.nationalCompilanceLevel;
    }

    public void setNationalCompilanceLevel(CompilanceLevel nationalLevel) {
        this.nationalCompilanceLevel = nationalLevel;
    }

    public void setNationalCompilanceLevel(String level) {
        if (StringUtils.isNotBlank((CharSequence)level)) {
            this.nationalCompilanceLevel = CompilanceLevel.byAbbreviation(level);
        }
    }

    public CompilanceLevel getMinimalCompilanceLevel() {
        return this.minimalCompilanceLevel;
    }

    public void setMinimalCompilanceLevel(String level) {
        if (StringUtils.isNotBlank((CharSequence)level)) {
            this.minimalCompilanceLevel = CompilanceLevel.byAbbreviation(level);
        }
    }

    public void setMinimalCompilanceLevel(CompilanceLevel minimalLevel) {
        this.minimalCompilanceLevel = minimalLevel;
    }

    public String toString() {
        return "DataFieldDefinition{tag='" + this.tag + '\'' + ", label='" + this.label + '\'' + ", cardinality=" + (Object)((Object)this.cardinality) + ", descriptionUrl='" + this.descriptionUrl + '\'' + '}';
    }
}

