/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.definition;

import de.gwdg.metadataqa.marc.MarcRecord;
import de.gwdg.metadataqa.marc.Validatable;
import de.gwdg.metadataqa.marc.definition.ControlSubfieldDefinition;
import de.gwdg.metadataqa.marc.definition.MarcVersion;
import de.gwdg.metadataqa.marc.definition.general.parser.ParserException;
import de.gwdg.metadataqa.marc.definition.general.parser.SubfieldContentParser;
import de.gwdg.metadataqa.marc.model.validation.ValidationError;
import de.gwdg.metadataqa.marc.model.validation.ValidationErrorType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class ControlValue
implements Validatable,
Serializable {
    private ControlSubfieldDefinition definition;
    private String value;
    private MarcRecord record;
    private List<ValidationError> validationErrors;

    public ControlValue(ControlSubfieldDefinition definition, String value) {
        this.definition = definition;
        this.value = value;
    }

    public void setRecord(MarcRecord record) {
        this.record = record;
    }

    public String getLabel() {
        return this.definition.getLabel();
    }

    public String getId() {
        return this.definition.getId();
    }

    public String resolve() {
        return this.definition.resolve(this.value);
    }

    public ControlSubfieldDefinition getDefinition() {
        return this.definition;
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public boolean validate(MarcVersion marcVersion) {
        boolean isValid = true;
        this.validationErrors = new ArrayList<ValidationError>();
        if (!this.definition.getValidCodes().isEmpty() && !this.definition.getValidCodes().contains(this.value) && this.definition.getCode(this.value) == null) {
            if (this.definition.isHistoricalCode(this.value)) {
                this.validationErrors.add(new ValidationError(this.record.getId(), this.definition.getPath(), ValidationErrorType.CONTROL_SUBFIELD_OBSOLETE_CODE, this.value, this.definition.getDescriptionUrl()));
                isValid = false;
            } else if (this.definition.isRepeatableContent()) {
                int unitLength = this.definition.getUnitLength();
                for (int i = 0; i < this.value.length(); i += unitLength) {
                    String unit = this.value.substring(i, i + unitLength);
                    if (this.definition.getValidCodes().contains(unit)) continue;
                    this.validationErrors.add(new ValidationError(this.record.getId(), this.definition.getPath(), ValidationErrorType.CONTROL_SUBFIELD_INVALID_CODE, String.format("'%s' in '%s'", unit, this.value), this.definition.getDescriptionUrl()));
                    isValid = false;
                }
            } else {
                this.validationErrors.add(new ValidationError(this.record == null ? null : this.record.getId(), this.definition.getPath(), ValidationErrorType.CONTROL_SUBFIELD_INVALID_VALUE, this.value, this.definition.getDescriptionUrl()));
                isValid = false;
            }
        }
        if (this.definition.hasParser()) {
            try {
                SubfieldContentParser parser = this.definition.getParser();
                parser.parse(this.value);
            }
            catch (ParserException e) {
                this.validationErrors.add(new ValidationError(this.record == null ? null : this.record.getId(), this.definition.getPath(), ValidationErrorType.CONTROL_SUBFIELD_INVALID_VALUE, e.getMessage(), this.definition.getDescriptionUrl()));
                isValid = false;
            }
        }
        return isValid;
    }

    @Override
    public List<ValidationError> getValidationErrors() {
        return this.validationErrors;
    }
}

