/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.datastore;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.response.UpdateResponse;
import org.apache.solr.common.SolrInputDocument;

public class MarcSolrClient {
    private String defaultUrl = "http://localhost:8983/solr/techproducts";
    private SolrClient solr;
    private boolean trimId = false;

    public MarcSolrClient() {
        this.initialize(this.defaultUrl);
    }

    public MarcSolrClient(String url) {
        this.initialize(url);
    }

    private void initialize(String url) {
        this.solr = new HttpSolrClient.Builder(url).build();
    }

    public void indexMap(String id, Map<String, List<String>> objectMap) throws IOException, SolrServerException {
        SolrInputDocument document = new SolrInputDocument(new String[0]);
        document.addField("id", (Object)(this.trimId ? id.trim() : id));
        for (Map.Entry<String, List<String>> entry : objectMap.entrySet()) {
            String key = entry.getKey();
            List<String> value = entry.getValue();
            if (value == null) continue;
            if (!key.endsWith("_sni") && !key.endsWith("_ss")) {
                key = key + "_ss";
            }
            document.addField(key, value);
        }
        try {
            UpdateResponse updateResponse = this.solr.add(document);
        }
        catch (HttpSolrClient.RemoteSolrException ex) {
            System.err.printf("document: %s", document);
            System.err.printf("Commit exception: %s%n", ex.getMessage());
        }
    }

    public void indexDuplumKey(String id, Map<String, Object> objectMap) throws IOException, SolrServerException {
        SolrInputDocument document = new SolrInputDocument(new String[0]);
        document.addField("id", (Object)id);
        for (Map.Entry<String, Object> entry : objectMap.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value == null) continue;
            if (!key.endsWith("_sni") && !key.endsWith("_ss")) {
                key = key + "_ss";
            }
            document.addField(key, value);
        }
        try {
            UpdateResponse updateResponse = this.solr.add(document);
        }
        catch (HttpSolrClient.RemoteSolrException ex) {
            System.err.printf("document: %s", document);
            System.err.printf("Commit exception: %s%n", ex.getMessage());
        }
    }

    public void commit() {
        try {
            this.solr.commit();
        }
        catch (IOException | SolrServerException e) {
            e.printStackTrace();
        }
    }

    public void optimize() {
        try {
            this.solr.optimize();
        }
        catch (IOException | SolrServerException e) {
            e.printStackTrace();
        }
    }

    public boolean getTrimId() {
        return this.trimId;
    }

    public void setTrimId(boolean trimId) {
        this.trimId = trimId;
    }
}

