/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.cli.utils;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class Schema {
    private static int SCHEMA_COUNTER = 0;
    private static Map<Schema, Integer> schemaCounter = new HashMap<Schema, Integer>();
    int id;
    String field;
    String location;
    String schema;
    String abbreviation;

    public Schema(String field, String location, String schema) {
        this.field = field;
        this.location = location;
        this.schema = schema;
        this.setId();
    }

    public Schema(String field, String location, String abbreviation, String schema) {
        this(field, location, schema);
        this.abbreviation = abbreviation;
    }

    private void setId() {
        if (!schemaCounter.containsKey(this)) {
            schemaCounter.put(this, ++SCHEMA_COUNTER);
        }
        this.id = schemaCounter.get(this);
    }

    public String getField() {
        return this.field;
    }

    public String getLocation() {
        return this.location;
    }

    public int getId() {
        return this.id;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getAbbreviation() {
        return this.abbreviation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Schema schema1 = (Schema)o;
        return new EqualsBuilder().append((Object)this.field, (Object)schema1.field).append((Object)this.location, (Object)schema1.location).append((Object)this.schema, (Object)schema1.schema).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.field).append((Object)this.location).append((Object)this.schema).toHashCode();
    }

    public String toString() {
        return "Schema{id=" + this.id + ", field='" + this.field + '\'' + ", location='" + this.location + '\'' + ", schema='" + this.schema + '\'' + ", abbreviation='" + this.abbreviation + '\'' + '}';
    }
}

