/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.cli.parameters;

import de.gwdg.metadataqa.marc.cli.parameters.CommonParameters;
import de.gwdg.metadataqa.marc.model.validation.ValidationErrorFormat;
import java.io.Serializable;
import org.apache.commons.cli.ParseException;

public class ValidatorParameters
extends CommonParameters
implements Serializable {
    public static final String DEFAULT_FILE_NAME = "validation-report.txt";
    private String detailsFileName = "validation-report.txt";
    private String summaryFileName;
    private boolean doDetails = true;
    private boolean doSummary = false;
    private ValidationErrorFormat format = ValidationErrorFormat.TEXT;
    private boolean useStandardOutput = false;
    private boolean isOptionSet;
    private boolean emptyLargeCollectors = false;

    @Override
    protected void setOptions() {
        if (!this.isOptionSet) {
            super.setOptions();
            this.options.addOption("g", "summaryFileName", true, "show summary instead of record level display");
            this.options.addOption("s", "summary", false, "show summary instead of record level display");
            this.options.addOption("t", "details", false, "show record level display");
            this.options.addOption("f", "detailsFileName", true, String.format("the report file name (default is '%s')", DEFAULT_FILE_NAME));
            this.options.addOption("r", "format", true, "specify a format");
            this.options.addOption("y", "emptyLargeCollectors", false, "empty large collectors");
            this.isOptionSet = true;
        }
    }

    public ValidatorParameters() {
    }

    public ValidatorParameters(String[] arguments) throws ParseException {
        super(arguments);
        if (this.cmd.hasOption("detailsFileName")) {
            this.detailsFileName = this.cmd.getOptionValue("detailsFileName");
        }
        if (this.cmd.hasOption("summaryFileName")) {
            this.summaryFileName = this.cmd.getOptionValue("summaryFileName");
            this.doSummary = true;
        }
        if (this.detailsFileName.equals("stdout")) {
            this.useStandardOutput = true;
        }
        if (this.cmd.hasOption("format")) {
            for (ValidationErrorFormat registeredFormat : ValidationErrorFormat.values()) {
                if (!registeredFormat.getNames().contains(this.cmd.getOptionValue("format"))) continue;
                this.format = registeredFormat;
                break;
            }
        }
        if (this.cmd.hasOption("summary")) {
            this.doSummary = true;
            if (!this.cmd.hasOption("details")) {
                this.doDetails = false;
            }
        }
        if (this.doDetails && this.doSummary && !this.useStandardOutput && this.summaryFileName == null) {
            throw new ParseException("If the details and summary is requested, summaryFileName must be provided!");
        }
        if (this.cmd.hasOption("emptyLargeCollectors")) {
            this.emptyLargeCollectors = true;
        }
    }

    public String getDetailsFileName() {
        return this.detailsFileName;
    }

    public boolean doSummary() {
        return this.doSummary;
    }

    public boolean doDetails() {
        return this.doDetails;
    }

    public boolean useStandardOutput() {
        return this.useStandardOutput;
    }

    public ValidationErrorFormat getFormat() {
        return this.format;
    }

    public String getSummaryFileName() {
        return this.summaryFileName;
    }

    public boolean doEmptyLargeCollectors() {
        return this.emptyLargeCollectors;
    }

    @Override
    public String formatParameters() {
        String text = super.formatParameters();
        text = text + String.format("details: %s%n", this.doSummary);
        text = text + String.format("summary: %s%n", this.doSummary);
        text = text + String.format("detailsFileName: %s%n", this.detailsFileName);
        text = text + String.format("summaryFileName: %s%n", this.summaryFileName);
        text = text + String.format("format: %s%n", this.format.getLabel());
        text = text + String.format("emptyLargeCollectors: %s%n", this.emptyLargeCollectors);
        return text;
    }
}

