/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.cli.parameters;

import de.gwdg.metadataqa.marc.Leader;
import de.gwdg.metadataqa.marc.definition.MarcVersion;
import java.io.Serializable;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang3.StringUtils;

public class CommonParameters
implements Serializable {
    protected String[] args;
    public static final String DEFAULT_OUTPUT_DIR = ".";
    protected MarcVersion marcVersion = MarcVersion.MARC21;
    protected boolean doHelp;
    protected boolean doLog = true;
    private int limit = -1;
    private int offset = -1;
    private String id = null;
    protected Leader.Type defaultRecordType = null;
    protected boolean fixAlephseq = false;
    protected boolean alephseq = false;
    protected boolean marcxml = false;
    protected boolean lineSeparated = false;
    protected boolean trimId = false;
    private String outputDir = ".";
    protected Options options = new Options();
    protected static final CommandLineParser parser = new DefaultParser();
    protected CommandLine cmd;
    private boolean isOptionSet = false;

    protected void setOptions() {
        if (!this.isOptionSet) {
            this.options.addOption("m", "marcVersion", true, "MARC version ('OCLC' or 'DNB')");
            this.options.addOption("h", "help", false, "display help");
            this.options.addOption("n", "nolog", false, "do not display log messages");
            this.options.addOption("l", "limit", true, "limit the number of records to process");
            this.options.addOption("o", "offset", true, "the first record to process");
            this.options.addOption("i", "id", true, "the MARC identifier (content of 001)");
            this.options.addOption("d", "defaultRecordType", true, "the default record type if the record's type is undetectable");
            this.options.addOption("q", "fixAlephseq", false, "fix the known issues of Alephseq format");
            this.options.addOption("p", "alephseq", false, "the source is in Alephseq format");
            this.options.addOption("x", "marcxml", false, "the source is in MARCXML format");
            this.options.addOption("y", "lineSeparated", false, "the source is in line separated MARC format");
            this.options.addOption("t", "outputDir", true, "output directory");
            this.options.addOption("r", "trimId", false, "remove spaces from the end of record IDs");
            this.isOptionSet = true;
        }
    }

    public CommonParameters() {
    }

    public CommonParameters(String[] arguments) throws ParseException {
        this.cmd = parser.parse(this.getOptions(), arguments);
        if (this.cmd.hasOption("marcVersion")) {
            this.marcVersion = MarcVersion.byCode(this.cmd.getOptionValue("marcVersion"));
            if (this.marcVersion == null) {
                throw new ParseException(String.format("Unrecognized marcVersion parameter value: '%s'", this.cmd.getOptionValue("marcVersion")));
            }
        }
        this.doHelp = this.cmd.hasOption("help");
        boolean bl = this.doLog = !this.cmd.hasOption("nolog");
        if (this.cmd.hasOption("limit")) {
            this.limit = Integer.parseInt(this.cmd.getOptionValue("limit"));
        }
        if (this.cmd.hasOption("offset")) {
            this.offset = Integer.parseInt(this.cmd.getOptionValue("offset"));
        }
        if (this.offset > -1 && this.limit > -1) {
            this.limit += this.offset;
        }
        if (this.cmd.hasOption("id")) {
            this.id = this.cmd.getOptionValue("id").trim();
        }
        if (this.cmd.hasOption("defaultRecordType")) {
            this.defaultRecordType = Leader.Type.valueOf(this.cmd.getOptionValue("defaultRecordType"));
        }
        this.alephseq = this.cmd.hasOption("alephseq");
        this.fixAlephseq = this.cmd.hasOption("fixAlephseq");
        this.marcxml = this.cmd.hasOption("marcxml");
        this.lineSeparated = this.cmd.hasOption("lineSeparated");
        if (this.cmd.hasOption("outputDir")) {
            this.outputDir = this.cmd.getOptionValue("outputDir");
        }
        this.trimId = this.cmd.hasOption("trimId");
        this.args = this.cmd.getArgs();
    }

    public Options getOptions() {
        if (!this.isOptionSet) {
            this.setOptions();
        }
        return this.options;
    }

    public MarcVersion getMarcVersion() {
        return this.marcVersion;
    }

    public boolean doHelp() {
        return this.doHelp;
    }

    public boolean doLog() {
        return this.doLog;
    }

    public String[] getArgs() {
        return this.args;
    }

    public int getLimit() {
        return this.limit;
    }

    public int getOffset() {
        return this.offset;
    }

    public boolean hasId() {
        return StringUtils.isNotBlank((CharSequence)this.id);
    }

    public String getId() {
        return this.id;
    }

    public Leader.Type getDefaultRecordType() {
        return this.defaultRecordType;
    }

    public boolean fixAlephseq() {
        return this.fixAlephseq;
    }

    public boolean isAlephseq() {
        return this.alephseq;
    }

    public boolean isMarcxml() {
        return this.marcxml;
    }

    public boolean isLineSeparated() {
        return this.lineSeparated;
    }

    public String getOutputDir() {
        return this.outputDir;
    }

    public boolean getTrimId() {
        return this.trimId;
    }

    public String formatParameters() {
        String text = "";
        text = text + String.format("marcVersion: %s, %s%n", this.marcVersion.getCode(), this.marcVersion.getLabel());
        text = text + String.format("limit: %d%n", this.limit);
        text = text + String.format("offset: %s%n", this.offset);
        text = text + String.format("MARC files: %s%n", StringUtils.join((Object[])this.args, (String)", "));
        text = text + String.format("id: %s%n", this.id);
        text = text + String.format("defaultRecordType: %s%n", new Object[]{this.defaultRecordType});
        text = text + String.format("fixAlephseq: %s%n", this.fixAlephseq);
        text = text + String.format("alephseq: %s%n", this.alephseq);
        text = text + String.format("marcxml: %s%n", this.marcxml);
        text = text + String.format("lineSeparated: %s%n", this.lineSeparated);
        text = text + String.format("outputDir: %s%n", this.outputDir);
        text = text + String.format("trimId: %s%n", this.trimId);
        return text;
    }
}

