/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.cli;

import de.gwdg.metadataqa.marc.DataField;
import de.gwdg.metadataqa.marc.MarcRecord;
import de.gwdg.metadataqa.marc.Utils;
import de.gwdg.metadataqa.marc.analysis.NetworkAnalyzer;
import de.gwdg.metadataqa.marc.cli.parameters.CommonParameters;
import de.gwdg.metadataqa.marc.cli.parameters.NetworkAction;
import de.gwdg.metadataqa.marc.cli.parameters.NetworkParameters;
import de.gwdg.metadataqa.marc.cli.processor.MarcFileProcessor;
import de.gwdg.metadataqa.marc.cli.utils.RecordIterator;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.marc4j.marc.Record;

public class NetworkAnalysis
implements MarcFileProcessor,
Serializable {
    private static final Logger logger = Logger.getLogger(NetworkAnalysis.class.getCanonicalName());
    private final NetworkParameters parameters;
    private final Options options;
    private final boolean readyToProcess;
    private final List<String> orphans = new ArrayList<String>();
    private Path path;
    private BufferedWriter writer;

    public NetworkAnalysis(String[] args) throws ParseException {
        this.parameters = new NetworkParameters(args);
        this.options = this.parameters.getOptions();
        this.readyToProcess = true;
    }

    public static void main(String[] args) {
        NetworkAnalysis processor = null;
        try {
            processor = new NetworkAnalysis(args);
        }
        catch (ParseException e) {
            System.err.println(Utils.createRow("ERROR. ", e.getLocalizedMessage()));
            System.exit(0);
        }
        logger.info("Action: " + (Object)((Object)((NetworkParameters)processor.getParameters()).getAction()));
        if (((NetworkParameters)processor.getParameters()).getAction().equals((Object)NetworkAction.PAIRING)) {
            processor.pairIds();
        } else {
            if (processor.getParameters().getArgs().length < 1) {
                System.err.println("Please provide a MARC file name!");
                processor.printHelp(processor.getParameters().getOptions());
                System.exit(0);
            }
            if (processor.getParameters().doHelp()) {
                processor.printHelp(processor.getParameters().getOptions());
                System.exit(0);
            }
            RecordIterator iterator = new RecordIterator(processor);
            iterator.start();
        }
    }

    private void pairIds() {
        logger.info("pairIds");
        Path outputPath = Paths.get(this.parameters.getOutputDir(), "network-pairs.csv");
        try {
            this.writer = Files.newBufferedWriter(outputPath, new OpenOption[0]);
            this.writer.write(Utils.createRow("id1", "id2"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        AtomicInteger lineNr = new AtomicInteger();
        Path inputPath = Paths.get(this.parameters.getOutputDir(), "network-by-concepts.csv");
        try (Stream<String> stream = Files.lines(Paths.get(inputPath.toString(), new String[0]));){
            stream.forEach(line -> {
                String[] parts;
                String[] ids;
                lineNr.getAndIncrement();
                if (lineNr.get() % 100 == 0) {
                    logger.info("" + lineNr.get());
                }
                if ((ids = (parts = line.split(","))[2].split(";")).length > 1) {
                    int i;
                    if (ids.length > this.parameters.getGroupLimit()) {
                        logger.info(String.format("%d is greater than %d. The array will will truncated.", ids.length, this.parameters.getGroupLimit()));
                        ids = Arrays.copyOfRange(ids, 0, this.parameters.getGroupLimit());
                    }
                    String[] encoded = new String[ids.length];
                    for (i = 0; i < ids.length; ++i) {
                        encoded[i] = this.encode(ids[i]);
                    }
                    for (i = 0; i < encoded.length - 1; ++i) {
                        for (int j = i + 1; j < encoded.length; ++j) {
                            try {
                                this.writer.write(Utils.createRow(encoded[i], encoded[j]));
                                continue;
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            this.writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String encode(String id) {
        if (id.contains("+")) {
            return id;
        }
        return Integer.toString(Integer.parseInt(id), 36);
    }

    @Override
    public CommonParameters getParameters() {
        return this.parameters;
    }

    @Override
    public void processRecord(Record marc4jRecord, int recordNumber) throws IOException {
    }

    @Override
    public void processRecord(MarcRecord marcRecord, int recordNumber) throws IOException {
        NetworkAnalyzer analyzer = new NetworkAnalyzer(marcRecord);
        Set<DataField> collector = analyzer.process(recordNumber);
        if (collector.size() > 0) {
            for (DataField field : collector) {
                this.writer.write(Utils.createRow(field.toString().hashCode(), recordNumber));
            }
        }
        this.orphans.add(marcRecord.getId(true));
    }

    @Override
    public void beforeIteration() {
        this.path = Paths.get(this.parameters.getOutputDir(), "network.csv");
        logger.info(this.parameters.formatParameters());
        try {
            this.writer = Files.newBufferedWriter(this.path, new OpenOption[0]);
            this.writer.write(Utils.createRow("concept", "id"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void fileOpened(Path path) {
    }

    @Override
    public void fileProcessed() {
    }

    @Override
    public void afterIteration(int numberOfprocessedRecords) {
    }

    @Override
    public void printHelp(Options options) {
    }

    @Override
    public boolean readyToProcess() {
        return this.readyToProcess;
    }
}

