/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.cli;

import de.gwdg.metadataqa.marc.MarcRecord;
import de.gwdg.metadataqa.marc.cli.parameters.CommonParameters;
import de.gwdg.metadataqa.marc.cli.parameters.MarcToSolrParameters;
import de.gwdg.metadataqa.marc.cli.processor.MarcFileProcessor;
import de.gwdg.metadataqa.marc.cli.utils.RecordIterator;
import de.gwdg.metadataqa.marc.datastore.MarcSolrClient;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Path;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang3.StringUtils;
import org.apache.solr.client.solrj.SolrServerException;
import org.marc4j.marc.Record;

public class MarcToSolr
implements MarcFileProcessor,
Serializable {
    private static final Logger logger = Logger.getLogger(MarcToSolr.class.getCanonicalName());
    private final Options options;
    private MarcToSolrParameters parameters;
    private MarcSolrClient client;
    private Path currentFile;
    private boolean readyToProcess;
    private DecimalFormat decimalFormat = new DecimalFormat();

    public MarcToSolr(String[] args) throws ParseException {
        this.parameters = new MarcToSolrParameters(args);
        this.options = this.parameters.getOptions();
        this.client = new MarcSolrClient(this.parameters.getSolrUrl());
        this.client.setTrimId(this.parameters.getTrimId());
        this.readyToProcess = true;
    }

    public static void main(String[] args) throws ParseException {
        MarcToSolr processor = new MarcToSolr(args);
        processor.options.toString();
        if (StringUtils.isBlank((CharSequence)((MarcToSolrParameters)processor.getParameters()).getSolrUrl())) {
            System.err.println("Please provide a Solr URL and file name!");
            System.exit(0);
        }
        RecordIterator iterator = new RecordIterator(processor);
        iterator.start();
    }

    @Override
    public CommonParameters getParameters() {
        return this.parameters;
    }

    @Override
    public void processRecord(Record marc4jRecord, int recordNumber) throws IOException {
    }

    @Override
    public void processRecord(MarcRecord marcRecord, int recordNumber) throws IOException {
        try {
            Map<String, List<String>> map = marcRecord.getKeyValuePairs(this.parameters.getSolrFieldType(), true);
            map.put("record_sni", Arrays.asList(marcRecord.asJson()));
            this.client.indexMap(marcRecord.getId(), map);
        }
        catch (SolrServerException e) {
            if (e.getMessage().contains("Server refused connection at")) {
                this.readyToProcess = false;
            }
            e.printStackTrace();
        }
        if (recordNumber % 5000 == 0) {
            if (this.parameters.doCommit()) {
                this.client.commit();
            }
            logger.info(String.format("%s/%s (%s)", this.currentFile.getFileName().toString(), this.decimalFormat.format(recordNumber), marcRecord.getId()));
        }
    }

    @Override
    public void beforeIteration() {
        logger.info(this.parameters.formatParameters());
    }

    @Override
    public void fileOpened(Path path) {
        this.currentFile = path;
    }

    @Override
    public void fileProcessed() {
    }

    @Override
    public void afterIteration(int numberOfprocessedRecords) {
        this.client.commit();
    }

    @Override
    public void printHelp(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        String message = String.format("java -cp metadata-qa-marc.jar %s [options] [file]", this.getClass().getCanonicalName());
        formatter.printHelp(message, options);
    }

    @Override
    public boolean readyToProcess() {
        return this.readyToProcess;
    }
}

