/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.cli;

import de.gwdg.metadataqa.marc.DataField;
import de.gwdg.metadataqa.marc.MarcControlField;
import de.gwdg.metadataqa.marc.MarcPositionalControlField;
import de.gwdg.metadataqa.marc.MarcRecord;
import de.gwdg.metadataqa.marc.MarcSubfield;
import de.gwdg.metadataqa.marc.cli.parameters.CompletenessParameters;
import de.gwdg.metadataqa.marc.cli.processor.MarcFileProcessor;
import de.gwdg.metadataqa.marc.cli.utils.RecordIterator;
import de.gwdg.metadataqa.marc.definition.ControlValue;
import de.gwdg.metadataqa.marc.definition.DataFieldDefinition;
import de.gwdg.metadataqa.marc.definition.FRBRFunction;
import de.gwdg.metadataqa.marc.definition.Indicator;
import de.gwdg.metadataqa.marc.model.validation.ValidationErrorFormat;
import de.gwdg.metadataqa.marc.utils.FrbrFunctionLister;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang3.StringUtils;
import org.marc4j.marc.Record;

public class FunctionalAnalysis
implements MarcFileProcessor,
Serializable {
    private static final Logger logger = Logger.getLogger(FunctionalAnalysis.class.getCanonicalName());
    private final Options options;
    private final boolean readyToProcess;
    private final CompletenessParameters parameters;
    private FrbrFunctionLister frbrFunctionLister;
    private int recordNumber;

    public FunctionalAnalysis(String[] args) throws ParseException {
        this.parameters = new CompletenessParameters(args);
        this.options = this.parameters.getOptions();
        this.readyToProcess = true;
        this.frbrFunctionLister = new FrbrFunctionLister();
        logger.info(this.frbrFunctionLister.getBaseline().toString());
    }

    public static void main(String[] args) {
        FunctionalAnalysis processor = null;
        try {
            processor = new FunctionalAnalysis(args);
        }
        catch (ParseException e) {
            logger.severe("ERROR. " + e.getLocalizedMessage());
            e.printStackTrace();
            System.exit(0);
        }
        if (processor.getParameters().getArgs().length < 1) {
            logger.severe("Please provide a MARC file name!");
            processor.printHelp(processor.getParameters().getOptions());
            System.exit(0);
        }
        if (processor.getParameters().doHelp()) {
            processor.printHelp(processor.getParameters().getOptions());
            System.exit(0);
        }
        RecordIterator iterator = new RecordIterator(processor);
        iterator.start();
    }

    @Override
    public CompletenessParameters getParameters() {
        return this.parameters;
    }

    @Override
    public void processRecord(Record marc4jRecord, int recordNumber) throws IOException {
    }

    @Override
    public void processRecord(MarcRecord marcRecord, int recordNumber) throws IOException {
        this.recordNumber = recordNumber;
        TreeMap<FRBRFunction, Integer> recordCounter = new TreeMap<FRBRFunction, Integer>();
        HashMap<DataFieldDefinition, Boolean> cache = new HashMap<DataFieldDefinition, Boolean>();
        this.countPositionalControlField(recordCounter, marcRecord.getLeader());
        this.countControlFields(recordCounter, marcRecord.getControlfields());
        this.countDataFields(recordCounter, marcRecord.getDatafields(), cache);
        Map<FRBRFunction, Double> percent = this.frbrFunctionLister.percent(recordCounter);
        this.frbrFunctionLister.add(percent);
        this.frbrFunctionLister.addToHistogram(percent);
    }

    private void countDataFields(Map<FRBRFunction, Integer> recordCounter, List<DataField> dataFields, Map<DataFieldDefinition, Boolean> cache) {
        for (DataField dataField : dataFields) {
            DataFieldDefinition definition = dataField.getDefinition();
            if (cache.containsKey(definition)) continue;
            cache.put(definition, true);
            this.countIndicator(recordCounter, definition.getInd1(), dataField.getInd1());
            this.countIndicator(recordCounter, definition.getInd2(), dataField.getInd2());
            for (MarcSubfield subfield : dataField.parseSubfields()) {
                if (subfield.getDefinition() == null || subfield.getDefinition().getFrbrFunctions() == null) continue;
                FrbrFunctionLister.countFunctions(subfield.getDefinition().getFrbrFunctions(), recordCounter);
            }
        }
    }

    private void countIndicator(Map<FRBRFunction, Integer> recordCounter, Indicator definition, String value) {
        if (definition.getFrbrFunctions() != null && StringUtils.isNotBlank((CharSequence)value)) {
            FrbrFunctionLister.countFunctions(definition.getFrbrFunctions(), recordCounter);
        }
    }

    private void countControlFields(Map<FRBRFunction, Integer> recordCounter, List<MarcControlField> controlFields) {
        for (MarcControlField controlField : controlFields) {
            if (controlField == null) continue;
            if (controlField instanceof MarcPositionalControlField) {
                this.countPositionalControlField(recordCounter, (MarcPositionalControlField)controlField);
                continue;
            }
            FrbrFunctionLister.countFunctions(controlField.getDefinition().getFrbrFunctions(), recordCounter);
        }
    }

    private void countPositionalControlField(Map<FRBRFunction, Integer> recordCounter, MarcPositionalControlField leader) {
        for (ControlValue controlValue : leader.getValuesList()) {
            FrbrFunctionLister.countFunctions(controlValue.getDefinition().getFrbrFunctions(), recordCounter);
        }
    }

    @Override
    public void beforeIteration() {
    }

    @Override
    public void fileOpened(Path path) {
    }

    @Override
    public void fileProcessed() {
    }

    @Override
    public void afterIteration(int numberOfprocessedRecords) {
        String fileExtension = ".csv";
        char separator = this.getSeparator(this.parameters.getFormat());
        if (this.parameters.getFormat().equals((Object)ValidationErrorFormat.TAB_SEPARATED)) {
            fileExtension = ".tsv";
        }
        Map<FRBRFunction, Double> result = this.frbrFunctionLister.percentOf(this.recordNumber);
        this.saveResult(result, fileExtension, separator);
        Map<FRBRFunction, Map<Double, Integer>> histogram = this.frbrFunctionLister.getHistogram();
        this.saveHistogram(histogram, fileExtension, separator);
    }

    private void saveHistogram(Map<FRBRFunction, Map<Double, Integer>> histogram, String fileExtension, char separator) {
        System.err.println("Functional analysis histogram");
        Path path = Paths.get(this.parameters.getOutputDir(), "functional-analysis-histogram" + fileExtension);
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            writer.write("frbrfunction" + separator + "score" + separator + "count\n");
            histogram.entrySet().stream().forEach(entry -> {
                try {
                    String function = ((FRBRFunction)((Object)((Object)entry.getKey()))).name();
                    Map histogramOfFunction = (Map)entry.getValue();
                    for (Map.Entry histogramEntry : histogramOfFunction.entrySet()) {
                        Double score = (Double)histogramEntry.getKey();
                        Integer count = (Integer)histogramEntry.getValue();
                        writer.write(StringUtils.join(Arrays.asList(function, score, count), (char)separator) + "\n");
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void saveResult(Map<FRBRFunction, Double> result, String fileExtension, char separator) {
        System.err.println("Functional analysis");
        Path path = Paths.get(this.parameters.getOutputDir(), "functional-analysis" + fileExtension);
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            writer.write("frbr-function" + separator + "score\n");
            result.entrySet().stream().forEach(entry -> {
                try {
                    writer.write(String.format("\"%s\"%s%f%n", ((FRBRFunction)((Object)((Object)entry.getKey()))).name(), Character.valueOf(separator), entry.getValue()));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private char getSeparator(ValidationErrorFormat format) {
        if (format.equals((Object)ValidationErrorFormat.TAB_SEPARATED)) {
            return '\t';
        }
        return ',';
    }

    @Override
    public void printHelp(Options options) {
    }

    @Override
    public boolean readyToProcess() {
        return this.readyToProcess;
    }
}

