/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.cli;

import de.gwdg.metadataqa.marc.MarcFactory;
import de.gwdg.metadataqa.marc.MarcRecord;
import de.gwdg.metadataqa.marc.cli.parameters.FormatterParameters;
import de.gwdg.metadataqa.marc.cli.processor.MarcFileProcessor;
import de.gwdg.metadataqa.marc.cli.utils.RecordIterator;
import de.gwdg.metadataqa.marc.utils.marcspec.legacy.MarcSpec;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang3.StringUtils;
import org.marc4j.marc.Record;

public class Formatter
implements MarcFileProcessor {
    private static final Logger logger = Logger.getLogger(Formatter.class.getCanonicalName());
    private FormatterParameters parameters;
    private boolean readyToProcess;

    public Formatter(String[] args) throws ParseException {
        this.parameters = new FormatterParameters(args);
        this.readyToProcess = true;
    }

    public static void main(String[] args) throws ParseException {
        System.err.println("'" + StringUtils.join((Object[])args, (String)"', '") + "'");
        Formatter processor = new Formatter(args);
        if (processor.getParameters().getArgs().length < 1) {
            System.err.println("Please provide a MARC file name!");
            System.exit(0);
        }
        if (processor.getParameters().doHelp()) {
            processor.printHelp(processor.getParameters().getOptions());
            System.exit(0);
        }
        RecordIterator iterator = new RecordIterator(processor);
        logger.info(processor.getParameters().formatParameters());
        iterator.start();
    }

    @Override
    public void printHelp(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        String message = String.format("java -cp metadata-qa-marc.jar %s [options] [file]", this.getClass().getCanonicalName());
        formatter.printHelp(message, options);
    }

    @Override
    public FormatterParameters getParameters() {
        return this.parameters;
    }

    @Override
    public void beforeIteration() {
        logger.info(this.parameters.formatParameters());
        if (this.parameters.hasSelector()) {
            ArrayList<String> values = new ArrayList<String>();
            if (this.parameters.withId()) {
                values.add("id");
            }
            for (MarcSpec marcSpec : this.parameters.getSelector()) {
                values.add(marcSpec.encode());
            }
            System.out.println(StringUtils.join(values, (String)"\t"));
        }
    }

    @Override
    public void fileOpened(Path file) {
    }

    @Override
    public void processRecord(Record marc4jRecord, int recordNumber) throws IOException {
        MarcRecord marcRecord;
        List<String> results;
        if (this.parameters.hasId() && marc4jRecord.getControlNumber() != null && marc4jRecord.getControlNumber().trim().equals(this.parameters.getId()) || this.parameters.getCountNr() > -1 && this.parameters.getCountNr() == recordNumber) {
            System.out.println(marc4jRecord.toString());
        }
        if (this.parameters.hasSearch() && !(results = (marcRecord = MarcFactory.createFromMarc4j(marc4jRecord)).search(this.parameters.getPath(), this.parameters.getQuery())).isEmpty()) {
            System.out.println(marc4jRecord.toString());
        }
        if (this.parameters.hasSelector()) {
            marcRecord = MarcFactory.createFromMarc4j(marc4jRecord);
            ArrayList<String> values = new ArrayList<String>();
            if (this.parameters.withId()) {
                values.add(marcRecord.getId());
            }
            for (MarcSpec marcSpec : this.parameters.getSelector()) {
                List<String> results2 = marcRecord.select(marcSpec);
                values.add(results2.isEmpty() ? "" : StringUtils.join(results2, (String)"||"));
            }
            System.out.println(StringUtils.join(values, (String)"\t"));
        }
    }

    @Override
    public void processRecord(MarcRecord marcRecord, int recordNumber) throws IOException {
    }

    @Override
    public void fileProcessed() {
    }

    @Override
    public void afterIteration(int numberOfprocessedRecords) {
    }

    @Override
    public boolean readyToProcess() {
        return this.readyToProcess;
    }
}

