/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.cli;

import de.gwdg.metadataqa.marc.DataField;
import de.gwdg.metadataqa.marc.MarcRecord;
import de.gwdg.metadataqa.marc.MarcSubfield;
import de.gwdg.metadataqa.marc.Utils;
import de.gwdg.metadataqa.marc.cli.parameters.CommonParameters;
import de.gwdg.metadataqa.marc.cli.parameters.CompletenessParameters;
import de.gwdg.metadataqa.marc.cli.processor.MarcFileProcessor;
import de.gwdg.metadataqa.marc.cli.utils.RecordIterator;
import de.gwdg.metadataqa.marc.definition.tags.TagCategory;
import de.gwdg.metadataqa.marc.model.validation.ValidationErrorFormat;
import de.gwdg.metadataqa.marc.utils.BasicStatistics;
import de.gwdg.metadataqa.marc.utils.TagHierarchy;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.marc4j.marc.Record;

public class Completeness
implements MarcFileProcessor,
Serializable {
    private static final Logger logger = Logger.getLogger(Completeness.class.getCanonicalName());
    private static final Pattern dataFieldPattern = Pattern.compile("^(\\d\\d\\d)\\$(.*)$");
    private final Options options;
    private CompletenessParameters parameters;
    private Map<String, Integer> library003Counter = new TreeMap<String, Integer>();
    private Map<String, Integer> libraryCounter = new TreeMap<String, Integer>();
    private Map<String, Integer> packageCounter = new TreeMap<String, Integer>();
    private Map<String, Map<String, Integer>> elementCardinality = new TreeMap<String, Map<String, Integer>>();
    private Map<String, Map<String, Integer>> elementFrequency = new TreeMap<String, Map<String, Integer>>();
    private Map<String, Map<Integer, Integer>> fieldHistogram = new HashMap<String, Map<Integer, Integer>>();
    private boolean readyToProcess;

    public Completeness(String[] args) throws ParseException {
        this.parameters = new CompletenessParameters(args);
        this.options = this.parameters.getOptions();
        this.readyToProcess = true;
    }

    public static void main(String[] args) {
        Completeness processor = null;
        try {
            processor = new Completeness(args);
        }
        catch (ParseException e) {
            System.err.println("ERROR. " + e.getLocalizedMessage());
            System.exit(0);
        }
        if (processor.getParameters().getArgs().length < 1) {
            System.err.println("Please provide a MARC file name!");
            processor.printHelp(processor.getParameters().getOptions());
            System.exit(0);
        }
        if (processor.getParameters().doHelp()) {
            processor.printHelp(processor.getParameters().getOptions());
            System.exit(0);
        }
        RecordIterator iterator = new RecordIterator(processor);
        iterator.start();
    }

    @Override
    public CommonParameters getParameters() {
        return this.parameters;
    }

    @Override
    public void processRecord(Record marc4jRecord, int recordNumber) throws IOException {
    }

    @Override
    public void processRecord(MarcRecord marcRecord, int recordNumber) throws IOException {
        TreeMap recordFrequency = new TreeMap();
        TreeMap recordPackageCounter = new TreeMap();
        String type = marcRecord.getType().getValue();
        if (marcRecord.getControl003() != null) {
            this.count(marcRecord.getControl003().getContent(), this.library003Counter);
        }
        for (String library : this.extract(marcRecord, "852", "a")) {
            this.count(library, this.libraryCounter);
        }
        for (DataField field : marcRecord.getDatafields()) {
            if (field.getDefinition() != null) {
                String packageName = Utils.extractPackageName(field);
                if (StringUtils.isBlank((CharSequence)packageName)) {
                    System.err.println(field + " has no package. /" + field.getDefinition().getClass());
                }
                this.count(packageName, recordPackageCounter);
            }
            for (MarcSubfield subfield : field.parseSubfields()) {
                String key = String.format("%s$%s", field.getTag(), subfield.getCode());
                if (!this.elementCardinality.containsKey(type)) {
                    this.elementCardinality.put(type, new TreeMap());
                }
                this.count(key, this.elementCardinality.get(type));
                this.count(key, this.elementCardinality.get("all"));
                this.count(key, recordFrequency);
            }
        }
        for (String key : recordFrequency.keySet()) {
            if (!this.elementFrequency.containsKey(type)) {
                this.elementFrequency.put(type, new TreeMap());
            }
            this.count(key, this.elementFrequency.get(type));
            this.count(key, this.elementFrequency.get("all"));
            if (!this.fieldHistogram.containsKey(key)) {
                this.fieldHistogram.put(key, new TreeMap());
            }
            this.count(recordFrequency.get(key), this.fieldHistogram.get(key));
        }
        for (String key : recordPackageCounter.keySet()) {
            this.count(key, this.packageCounter);
        }
    }

    private List<String> extract(MarcRecord marcRecord, String tag, String subfield) {
        ArrayList<String> values = new ArrayList<String>();
        List<DataField> fields = marcRecord.getDatafield(tag);
        if (fields != null && !fields.isEmpty()) {
            for (DataField field : fields) {
                List<MarcSubfield> subfieldInstances = field.getSubfield(subfield);
                if (subfieldInstances == null) continue;
                for (MarcSubfield subfieldInstance : subfieldInstances) {
                    values.add(subfieldInstance.getValue());
                }
            }
        }
        return values;
    }

    private <T> void count(T key, Map<T, Integer> counter) {
        if (!counter.containsKey(key)) {
            counter.put(key, 0);
        }
        counter.put(key, counter.get(key) + 1);
    }

    private void mapItem(String key, Map<String, Integer> counter) {
        if (!counter.containsKey(key)) {
            counter.put(key, counter.size() + 1);
        }
        counter.get(key);
    }

    @Override
    public void beforeIteration() {
        logger.info(this.parameters.formatParameters());
        this.elementCardinality.put("all", new TreeMap());
        this.elementFrequency.put("all", new TreeMap());
    }

    @Override
    public void fileOpened(Path file) {
    }

    @Override
    public void fileProcessed() {
    }

    @Override
    public void afterIteration(int numberOfprocessedRecords) {
        DecimalFormat format = new DecimalFormat();
        String fileExtension = ".csv";
        char separator = this.getSeparator(this.parameters.getFormat());
        if (this.parameters.getFormat().equals((Object)ValidationErrorFormat.TAB_SEPARATED)) {
            fileExtension = ".tsv";
        }
        this.saveLibraries003(fileExtension, separator);
        this.saveLibraries(fileExtension, separator);
        this.savePackages(fileExtension, separator);
        this.saveMarcElements(fileExtension, separator);
    }

    private void saveLibraries003(String fileExtension, char separator) {
        System.err.println("Libraries003");
        Path path = Paths.get(this.parameters.getOutputDir(), "libraries003" + fileExtension);
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            writer.write("library" + separator + "count\n");
            this.library003Counter.entrySet().stream().forEach(entry -> {
                try {
                    writer.write(String.format("\"%s\"%s%d%n", entry.getKey(), Character.valueOf(separator), entry.getValue()));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void saveMarcElements(String fileExtension, char separator) {
        System.err.println("MARC elements");
        Path path = Paths.get(this.parameters.getOutputDir(), "marc-elements" + fileExtension);
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            writer.write(StringUtils.join(Arrays.asList("type", "path", "package", "tag", "subfield", "number-of-record", "number-of-instances", "min", "max", "mean", "stddev", "histogram"), (char)separator) + "\n");
            this.elementCardinality.keySet().stream().forEach(type -> this.elementCardinality.get(type).entrySet().stream().forEach(entry -> {
                try {
                    writer.write(this.formatCardinality(separator, (Map.Entry<String, Integer>)entry, (String)type));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void savePackages(String fileExtension, char separator) {
        System.err.println("Packages");
        Path path = Paths.get(this.parameters.getOutputDir(), "packages" + fileExtension);
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            writer.write(Utils.createRow(Character.valueOf(separator), "name", "label", "iscoretag", "count"));
            this.packageCounter.entrySet().stream().forEach(entry -> {
                try {
                    String name = (String)entry.getKey();
                    int count = (Integer)entry.getValue();
                    TagCategory tagCategory = TagCategory.getPackage(name);
                    String label = "";
                    boolean isPartOfMarcScore = false;
                    if (tagCategory != null) {
                        name = tagCategory.getRange();
                        label = tagCategory.getLabel();
                        isPartOfMarcScore = tagCategory.isPartOfMarcCore();
                    }
                    writer.write(Utils.createRow(Character.valueOf(separator), Utils.quote(name), Utils.quote(label), isPartOfMarcScore, count));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void saveLibraries(String fileExtension, char separator) {
        System.err.println("Libraries");
        Path path = Paths.get(this.parameters.getOutputDir(), "libraries" + fileExtension);
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            writer.write("library" + separator + "count\n");
            this.libraryCounter.entrySet().stream().forEach(entry -> {
                try {
                    writer.write(String.format("\"%s\"%s%d%n", entry.getKey(), Character.valueOf(separator), entry.getValue()));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @NotNull
    private String formatCardinality(char separator, Map.Entry<String, Integer> entry, String type) {
        String key = entry.getKey();
        if (key.equals("")) {
            logger.severe("Empty key from " + key);
        }
        TagHierarchy tagHierarchy = TagHierarchy.createFromPath(key);
        String packageLabel = "";
        String tagLabel = "";
        String subfieldLabel = "";
        if (tagHierarchy != null) {
            packageLabel = tagHierarchy.getPackageLabel();
            tagLabel = tagHierarchy.getTagLabel();
            subfieldLabel = tagHierarchy.getSubfieldLabel();
        } else {
            logger.severe("Key can not be found in the TagHierarchy: " + key);
        }
        Integer cardinality = entry.getValue();
        Integer frequency = this.elementFrequency.get(type).get(key);
        BasicStatistics statistics = new BasicStatistics(this.fieldHistogram.get(key));
        if (!this.fieldHistogram.containsKey(key)) {
            logger.warning(String.format("Field %s is not registered in histogram", key));
        }
        List<Object> values = Utils.quote(Arrays.asList(type, key, packageLabel, tagLabel, subfieldLabel, frequency, cardinality, statistics.getMin(), statistics.getMax(), statistics.getMean(), statistics.getStdDev(), statistics.formatHistogram()));
        String record = StringUtils.join(values, (char)separator) + "\n";
        return record;
    }

    private char getSeparator(ValidationErrorFormat format) {
        if (format.equals((Object)ValidationErrorFormat.TAB_SEPARATED)) {
            return '\t';
        }
        return ',';
    }

    @Override
    public void printHelp(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        String message = String.format("java -cp metadata-qa-marc.jar %s [options] [file]", this.getClass().getCanonicalName());
        formatter.printHelp(message, options);
    }

    @Override
    public boolean readyToProcess() {
        return this.readyToProcess;
    }
}

