/*
 * Decompiled with CFR 0.152.
 */
package de.gwdg.metadataqa.marc.analysis;

import de.gwdg.metadataqa.marc.Utils;
import de.gwdg.metadataqa.marc.analysis.ThompsonTraillFields;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class ThompsonTraillScores {
    private Map<ThompsonTraillFields, Integer> scores = new LinkedHashMap<ThompsonTraillFields, Integer>();

    public ThompsonTraillScores() {
        for (ThompsonTraillFields field : ThompsonTraillFields.values()) {
            if (field.equals((Object)ThompsonTraillFields.ID)) continue;
            this.scores.put(field, 0);
        }
    }

    public void count(ThompsonTraillFields key) {
        Utils.count(key, this.scores);
    }

    public void set(ThompsonTraillFields key, int value) {
        this.scores.put(key, value);
    }

    public void calculateTotal() {
        int total = 0;
        for (Map.Entry<ThompsonTraillFields, Integer> entry : this.scores.entrySet()) {
            ThompsonTraillFields field = entry.getKey();
            if (field.equals((Object)ThompsonTraillFields.TOTAL)) continue;
            if (field.isClassification()) {
                total += Math.min(entry.getValue(), 10);
                continue;
            }
            total += entry.getValue().intValue();
        }
        this.set(ThompsonTraillFields.TOTAL, total);
    }

    public List<Integer> asList() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (Map.Entry<ThompsonTraillFields, Integer> entry : this.scores.entrySet()) {
            ThompsonTraillFields field = entry.getKey();
            if (field.isClassification()) {
                list.add(Math.min(entry.getValue(), 10));
                continue;
            }
            list.add(entry.getValue());
        }
        return list;
    }
}

